/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSetPassengersPacket
implements MinecraftPacket {
    private final int entityId;
    private final int @lombok.NonNull [] passengerIds;

    public ClientboundSetPassengersPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.passengerIds = new int[MinecraftTypes.readVarInt(in)];
        for (int index = 0; index < this.passengerIds.length; ++index) {
            this.passengerIds[index] = MinecraftTypes.readVarInt(in);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeVarInt(out, this.passengerIds.length);
        for (int entityId : this.passengerIds) {
            MinecraftTypes.writeVarInt(out, entityId);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int @lombok.NonNull [] getPassengerIds() {
        return this.passengerIds;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetPassengersPacket)) {
            return false;
        }
        ClientboundSetPassengersPacket other = (ClientboundSetPassengersPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.equals(this.getPassengerIds(), other.getPassengerIds());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetPassengersPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.hashCode(this.getPassengerIds());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetPassengersPacket(entityId=" + this.getEntityId() + ", passengerIds=" + Arrays.toString(this.getPassengerIds()) + ")";
    }

    public @NonNull ClientboundSetPassengersPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetPassengersPacket(entityId, this.passengerIds);
    }

    public @NonNull ClientboundSetPassengersPacket withPassengerIds(int @lombok.NonNull [] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        return this.passengerIds == passengerIds ? this : new ClientboundSetPassengersPacket(this.entityId, passengerIds);
    }

    public ClientboundSetPassengersPacket(int entityId, int @lombok.NonNull [] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        this.entityId = entityId;
        this.passengerIds = passengerIds;
    }
}

