/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.entity.custom.CustomEntityDefinition;
import org.geysermc.geyser.api.entity.custom.CustomJavaEntityType;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.entity.property.type.GeyserFloatEntityProperty;
import org.geysermc.geyser.api.entity.property.type.GeyserStringEnumProperty;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineEntitiesEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineEntityPropertiesEvent;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.BedrockEntityDefinition;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.entity.GeyserEntityType;
import org.geysermc.geyser.entity.NonVanillaEntityTypeDefinition;
import org.geysermc.geyser.entity.VanillaEntities;
import org.geysermc.geyser.entity.properties.type.BooleanProperty;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.properties.type.FloatProperty;
import org.geysermc.geyser.entity.properties.type.IntProperty;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.entity.properties.type.StringEnumProperty;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.ChestBoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.TextDisplayEntity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.living.animal.HappyGhastEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.GeyserHolderSet;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.GameType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;

public final class EntityUtils {
    private static final AtomicInteger RUNTIME_ID_ALLOCATOR = new AtomicInteger(100000);
    public static final Hand[] HANDS = Hand.values();

    public static String[] getAllEffectIdentifiers() {
        String[] identifiers = new String[Effect.VALUES.length];
        for (int i = 0; i < Effect.VALUES.length; ++i) {
            identifiers[i] = "minecraft:" + Effect.VALUES[i].name().toLowerCase(Locale.ROOT);
        }
        return identifiers;
    }

    private static float getMountedHeightOffset(Entity mount) {
        BoatEntity boat;
        if (mount instanceof BoatEntity && (boat = (BoatEntity)mount).getVariant() != BoatEntity.BoatVariant.BAMBOO) {
            return -0.1f;
        }
        float height = mount.getBoundingBoxHeight();
        float mountedHeightOffset = height * 0.75f;
        EntityTypeDefinition<?> definition = mount.getJavaTypeDefinition();
        if (definition.is(BuiltinEntityType.CAMEL)) {
            boolean isBaby = mount.getFlag(EntityFlag.BABY);
            mountedHeightOffset = height - (isBaby ? 0.35f : 0.6f);
        } else if (definition.is(BuiltinEntityType.CAVE_SPIDER) || definition.is(BuiltinEntityType.CHICKEN) || definition.is(BuiltinEntityType.SPIDER)) {
            mountedHeightOffset = height * 0.5f;
        } else if (definition.is(BuiltinEntityType.DONKEY) || definition.is(BuiltinEntityType.MULE)) {
            mountedHeightOffset -= 0.25f;
        } else if (definition.is(BuiltinEntityType.TRADER_LLAMA) || definition.is(BuiltinEntityType.LLAMA)) {
            mountedHeightOffset = height * 0.6f;
        } else if (definition.is(BuiltinEntityType.MINECART) || definition.is(BuiltinEntityType.HOPPER_MINECART) || definition.is(BuiltinEntityType.TNT_MINECART) || definition.is(BuiltinEntityType.CHEST_MINECART) || definition.is(BuiltinEntityType.FURNACE_MINECART) || definition.is(BuiltinEntityType.SPAWNER_MINECART) || definition.is(BuiltinEntityType.COMMAND_BLOCK_MINECART)) {
            mountedHeightOffset = 0.0f;
        } else if (definition.is(BuiltinEntityType.BAMBOO_RAFT) || definition.is(BuiltinEntityType.BAMBOO_CHEST_RAFT)) {
            mountedHeightOffset = 0.25f;
        } else if (definition.is(BuiltinEntityType.HOGLIN) || definition.is(BuiltinEntityType.ZOGLIN)) {
            boolean isBaby = mount.getFlag(EntityFlag.BABY);
            mountedHeightOffset = height - (isBaby ? 0.2f : 0.15f);
        } else if (definition.is(BuiltinEntityType.PIGLIN)) {
            mountedHeightOffset = height * 0.92f;
        } else if (definition.is(BuiltinEntityType.PHANTOM)) {
            mountedHeightOffset = height * 0.35f;
        } else if (definition.is(BuiltinEntityType.RAVAGER)) {
            mountedHeightOffset = 2.1f;
        } else if (definition.is(BuiltinEntityType.SKELETON_HORSE)) {
            mountedHeightOffset -= 0.1875f;
        } else if (definition.is(BuiltinEntityType.SNIFFER)) {
            mountedHeightOffset = 1.8f;
        } else if (definition.is(BuiltinEntityType.STRIDER)) {
            mountedHeightOffset = height - 0.19f;
        }
        return mountedHeightOffset;
    }

    private static float getHeightOffset(Entity passenger) {
        Entity vehicle;
        EntityTypeDefinition<?> definition = passenger.getJavaTypeDefinition();
        if (definition.is(BuiltinEntityType.ALLAY) || definition.is(BuiltinEntityType.VEX)) {
            return 0.4f;
        }
        if (definition.is(BuiltinEntityType.SKELETON) || definition.is(BuiltinEntityType.STRAY) || definition.is(BuiltinEntityType.WITHER_SKELETON)) {
            return -0.6f;
        }
        if (definition.is(BuiltinEntityType.ARMOR_STAND)) {
            if (((ArmorStandEntity)passenger).isMarker()) {
                return 0.0f;
            }
            return 0.1f;
        }
        if (definition.is(BuiltinEntityType.ENDERMITE) || definition.is(BuiltinEntityType.SILVERFISH)) {
            return 0.1f;
        }
        if (definition.is(BuiltinEntityType.PIGLIN) || definition.is(BuiltinEntityType.PIGLIN_BRUTE) || definition.is(BuiltinEntityType.ZOMBIFIED_PIGLIN)) {
            boolean isBaby = passenger.getFlag(EntityFlag.BABY);
            return isBaby ? -0.05f : -0.45f;
        }
        if (definition.is(BuiltinEntityType.DROWNED) || definition.is(BuiltinEntityType.HUSK) || definition.is(BuiltinEntityType.ZOMBIE_VILLAGER) || definition.is(BuiltinEntityType.ZOMBIE)) {
            boolean isBaby = passenger.getFlag(EntityFlag.BABY);
            return isBaby ? 0.0f : -0.45f;
        }
        if (definition.is(BuiltinEntityType.EVOKER) || definition.is(BuiltinEntityType.ILLUSIONER) || definition.is(BuiltinEntityType.PILLAGER) || definition.is(BuiltinEntityType.RAVAGER) || definition.is(BuiltinEntityType.VINDICATOR) || definition.is(BuiltinEntityType.WITCH)) {
            return -0.45f;
        }
        if (definition.is(BuiltinEntityType.PLAYER)) {
            return -0.35f;
        }
        if (definition.is(BuiltinEntityType.SHULKER) && ((vehicle = passenger.getVehicle()) instanceof BoatEntity || vehicle.getJavaTypeDefinition() == VanillaEntities.MINECART)) {
            return 0.1875f - EntityUtils.getMountedHeightOffset(vehicle);
        }
        if (passenger instanceof AnimalEntity) {
            return 0.14f;
        }
        return 0.0f;
    }

    public static void updateMountOffset(Entity passenger, Entity mount, boolean rider, boolean riding, int index, int passengers) {
        passenger.setFlag(EntityFlag.RIDING, riding);
        if (riding) {
            float mountedHeightOffset = EntityUtils.getMountedHeightOffset(mount);
            float heightOffset = EntityUtils.getHeightOffset(passenger);
            float xOffset = 0.0f;
            float yOffset = mountedHeightOffset + heightOffset;
            float zOffset = 0.0f;
            EntityTypeDefinition<?> mountDefinition = mount.getJavaTypeDefinition();
            if (mountDefinition.is(BuiltinEntityType.CAMEL)) {
                zOffset = 0.5f;
                if (passengers > 1) {
                    if (!rider) {
                        zOffset = -0.7f;
                    }
                    if (passenger instanceof AnimalEntity) {
                        zOffset += 0.2f;
                    }
                }
                if (mount.getFlag(EntityFlag.SITTING)) {
                    yOffset = mount.getFlag(EntityFlag.BABY) ? (yOffset += 0.715f) : (yOffset += 1.43f);
                }
            } else if (mountDefinition.is(BuiltinEntityType.CHICKEN)) {
                zOffset = -0.1f;
            } else if (mountDefinition.is(BuiltinEntityType.TRADER_LLAMA) || mountDefinition.is(BuiltinEntityType.LLAMA)) {
                zOffset = -0.3f;
            } else if (mountDefinition.is(BuiltinEntityType.TEXT_DISPLAY)) {
                if (passenger instanceof TextDisplayEntity) {
                    TextDisplayEntity textDisplay = (TextDisplayEntity)passenger;
                    displayTranslation = textDisplay.getTranslation();
                    if (displayTranslation == null) {
                        return;
                    }
                    xOffset = displayTranslation.getX();
                    yOffset = displayTranslation.getY() + 0.2f;
                    zOffset = displayTranslation.getZ();
                }
            } else if (mountDefinition.is(BuiltinEntityType.PLAYER)) {
                if (passenger instanceof TextDisplayEntity) {
                    TextDisplayEntity textDisplay = (TextDisplayEntity)passenger;
                    displayTranslation = textDisplay.getTranslation();
                    int lines = textDisplay.getLineCount();
                    if (displayTranslation != null && lines != 0) {
                        float multiplier = 0.1414f;
                        xOffset = displayTranslation.getX();
                        yOffset += displayTranslation.getY() + multiplier * (float)lines;
                        zOffset = displayTranslation.getZ();
                    }
                }
            } else if (mountDefinition.is(BuiltinEntityType.HAPPY_GHAST)) {
                int seatingIndex = Math.min(index, 3);
                xOffset = HappyGhastEntity.X_OFFSETS[seatingIndex];
                yOffset = 3.4f;
                zOffset = HappyGhastEntity.Z_OFFSETS[seatingIndex];
            }
            if (mount instanceof ChestBoatEntity) {
                xOffset = 0.15f;
            } else if (mount instanceof BoatEntity && passengers > 1) {
                float f = xOffset = rider ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    xOffset += 0.2f;
                }
            }
            EntityTypeDefinition<?> passengerDefinition = passenger.getJavaTypeDefinition();
            if (mountDefinition.is(BuiltinEntityType.PLAYER)) {
                yOffset -= VanillaEntities.PLAYER_ENTITY_OFFSET;
            }
            if (passengerDefinition.is(BuiltinEntityType.PLAYER)) {
                yOffset += VanillaEntities.PLAYER_ENTITY_OFFSET;
            }
            if (mountDefinition.is(BuiltinEntityType.MINECART) || mountDefinition.is(BuiltinEntityType.HOPPER_MINECART) || mountDefinition.is(BuiltinEntityType.TNT_MINECART) || mountDefinition.is(BuiltinEntityType.CHEST_MINECART) || mountDefinition.is(BuiltinEntityType.FURNACE_MINECART) || mountDefinition.is(BuiltinEntityType.SPAWNER_MINECART) || mountDefinition.is(BuiltinEntityType.COMMAND_BLOCK_MINECART)) {
                yOffset -= mount.height() * 0.5f;
            }
            if (passengerDefinition.is(BuiltinEntityType.MINECART) || passengerDefinition.is(BuiltinEntityType.HOPPER_MINECART) || passengerDefinition.is(BuiltinEntityType.TNT_MINECART) || passengerDefinition.is(BuiltinEntityType.CHEST_MINECART) || passengerDefinition.is(BuiltinEntityType.FURNACE_MINECART) || passengerDefinition.is(BuiltinEntityType.SPAWNER_MINECART) || passengerDefinition.is(BuiltinEntityType.COMMAND_BLOCK_MINECART) || passengerDefinition.is(BuiltinEntityType.SHULKER)) {
                yOffset += passenger.height() * 0.5f;
            } else if (passengerDefinition.is(BuiltinEntityType.FALLING_BLOCK)) {
                yOffset += 0.995f;
            }
            if (mount instanceof BoatEntity) {
                yOffset -= mount.height() * 0.5f;
            }
            if (passenger instanceof BoatEntity) {
                yOffset += passenger.height() * 0.5f;
            }
            if (mount instanceof ArmorStandEntity) {
                ArmorStandEntity armorStand = (ArmorStandEntity)mount;
                yOffset -= armorStand.getYOffset();
            }
            passenger.setRiderSeatPosition(Vector3f.from((float)xOffset, (float)yOffset, (float)zOffset));
        }
    }

    public static void updateRiderRotationLock(Entity passenger, Entity mount, boolean isRiding) {
        if (isRiding && mount instanceof BoatEntity) {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(90.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(-90.0f));
        } else {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(0.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(0.0f));
        }
    }

    public static boolean attemptToBucket(GeyserItemStack itemInHand) {
        return itemInHand.is(Items.WATER_BUCKET);
    }

    public static InteractionResult attemptToSaddle(Entity entityToSaddle, GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.SADDLE) && !entityToSaddle.getFlag(EntityFlag.SADDLED) && !entityToSaddle.getFlag(EntityFlag.BABY)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static GameType toBedrockGamemode(GameMode gamemode) {
        return switch (gamemode) {
            case GameMode.CREATIVE -> GameType.CREATIVE;
            case GameMode.ADVENTURE -> GameType.ADVENTURE;
            case GameMode.SPECTATOR -> GameType.SURVIVAL_VIEWER;
            default -> GameType.SURVIVAL;
        };
    }

    private static String translatedEntityName(@NonNull String namespace, @NonNull String name, @NonNull GeyserSession session) {
        if (EnvironmentUtils.IS_UNIT_TESTING) {
            return "entity." + namespace + "." + name;
        }
        return MinecraftLocale.getLocaleString("entity." + namespace + "." + name, session.locale());
    }

    public static String translatedEntityName(@NonNull Key type, @NonNull GeyserSession session) {
        return EntityUtils.translatedEntityName(type.namespace(), type.value(), session);
    }

    public static String translatedEntityName(@Nullable GeyserEntityType type, @NonNull GeyserSession session) {
        if (type == null || type.isUnregistered()) {
            return "entity.unregistered_sadface";
        }
        if (type.is(BuiltinEntityType.PLAYER)) {
            return "Player";
        }
        Identifier typeName = type.identifier();
        return EntityUtils.translatedEntityName(typeName.namespace(), typeName.path(), session);
    }

    public static boolean equipmentUsableByEntity(GeyserSession session, Equippable equippable, GeyserEntityType entity) {
        if (equippable.allowedEntities() == null) {
            return true;
        }
        GeyserHolderSet<GeyserEntityType> holderSet = GeyserHolderSet.fromHolderSet(JavaRegistries.ENTITY_TYPE, equippable.allowedEntities());
        return holderSet.contains(session, entity);
    }

    public static UUID uuidFromIntArray(int[] uuid) {
        if (uuid != null && uuid.length == 4) {
            return new UUID((long)uuid[0] << 32 | (long)uuid[1] & 0xFFFFFFFFL, (long)uuid[2] << 32 | (long)uuid[3] & 0xFFFFFFFFL);
        }
        return null;
    }

    public static void callEntityEvents() {
        final ArrayList customEntities = new ArrayList();
        GeyserImpl.getInstance().getEventBus().fire(new GeyserDefineEntitiesEvent(){

            @Override
            public Collection<GeyserEntityDefinition> entities() {
                return Collections.unmodifiableCollection(((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).values());
            }

            @Override
            public Collection<CustomEntityDefinition> customEntities() {
                return Collections.unmodifiableCollection(customEntities);
            }

            @Override
            public void register(@NonNull CustomEntityDefinition entityDefinition) {
                Objects.requireNonNull(entityDefinition);
                if (!(entityDefinition instanceof BedrockEntityDefinition)) {
                    throw new IllegalArgumentException("EntityDefinition must not be a custom implementation of BedrockEntityDefinition! Found " + entityDefinition.getClass().getSimpleName());
                }
                BedrockEntityDefinition bedrockEntityDefinition = (BedrockEntityDefinition)entityDefinition;
                if (entityDefinition.registered()) {
                    throw new IllegalStateException("Duplicate custom entity definition: " + String.valueOf(entityDefinition));
                }
                if (bedrockEntityDefinition.vanilla()) {
                    throw new IllegalStateException("Cannot register entity in vanilla namespace! " + String.valueOf(bedrockEntityDefinition.identifier()));
                }
                Registries.BEDROCK_ENTITY_DEFINITIONS.register(bedrockEntityDefinition.identifier(), bedrockEntityDefinition);
                customEntities.add(bedrockEntityDefinition);
            }

            @Override
            public void registerEntityType(Consumer<CustomJavaEntityType.Builder> consumer) {
                GeyserEntityType.Builder builder = new GeyserEntityType.Builder();
                consumer.accept(builder);
                GeyserEntityType type = GeyserEntityType.createCustomAndRegister(builder);
                GeyserEntityDefinition defaultBedrockDefinition = type.defaultBedrockDefinition();
                if (defaultBedrockDefinition != null && !this.isRegistered(defaultBedrockDefinition)) {
                    throw new IllegalStateException("Default bedrock entity definition has not been registered!");
                }
                NonVanillaEntityTypeDefinition definition = new NonVanillaEntityTypeDefinition(builder, type);
                Registries.JAVA_ENTITY_TYPES.register(type, definition);
                Registries.JAVA_ENTITY_IDENTIFIERS.register(type.identifier().toString(), definition);
            }

            public boolean isRegistered(GeyserEntityDefinition definition) {
                return ((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).containsKey(definition.identifier());
            }
        });
        if (!customEntities.isEmpty()) {
            NbtMap nbt = (NbtMap)Registries.BEDROCK_ENTITY_IDENTIFIERS.get();
            ArrayList<NbtMap> idlist = new ArrayList<NbtMap>(nbt.getList("idlist", NbtType.COMPOUND));
            for (BedrockEntityDefinition definition : customEntities) {
                idlist.add(NbtMap.builder().putBoolean("hasSpawnEgg", false).putString("id", definition.identifier().toString()).putBoolean("summonable", true).putString("bid", "").putInt("rid", RUNTIME_ID_ALLOCATOR.getAndIncrement()).putBoolean("experimental", false).build());
                GeyserImpl.getInstance().getLogger().debug("Registered custom entity " + String.valueOf(definition.identifier()));
            }
            NbtMap newIdentifiers = nbt.toBuilder().putList("idlist", NbtType.COMPOUND, idlist).build();
            Registries.BEDROCK_ENTITY_IDENTIFIERS.set(newIdentifiers);
            GeyserImpl.getInstance().getLogger().info("Registered " + customEntities.size() + " custom entities");
        }
        GeyserImpl.getInstance().getEventBus().fire(new GeyserDefineEntityPropertiesEvent(){

            @Override
            public GeyserFloatEntityProperty registerFloatProperty(@NonNull Identifier identifier, @NonNull Identifier propertyId, float min, float max, @Nullable Float defaultValue) {
                Objects.requireNonNull(identifier);
                Objects.requireNonNull(propertyId);
                if (propertyId.vanilla()) {
                    throw new IllegalArgumentException("Cannot register custom property in vanilla namespace! " + String.valueOf(propertyId));
                }
                FloatProperty property = new FloatProperty(propertyId, max, min, defaultValue);
                EntityUtils.registerProperty(identifier, property);
                return property;
            }

            @Override
            public IntProperty registerIntegerProperty(@NonNull Identifier identifier, @NonNull Identifier propertyId, int min, int max, @Nullable Integer defaultValue) {
                Objects.requireNonNull(identifier);
                Objects.requireNonNull(propertyId);
                if (propertyId.vanilla()) {
                    throw new IllegalArgumentException("Cannot register custom property in vanilla namespace! " + String.valueOf(propertyId));
                }
                IntProperty property = new IntProperty(propertyId, max, min, defaultValue);
                EntityUtils.registerProperty(identifier, property);
                return property;
            }

            @Override
            public BooleanProperty registerBooleanProperty(@NonNull Identifier identifier, @NonNull Identifier propertyId, boolean defaultValue) {
                Objects.requireNonNull(identifier);
                Objects.requireNonNull(propertyId);
                if (propertyId.vanilla()) {
                    throw new IllegalArgumentException("Cannot register custom property in vanilla namespace! " + String.valueOf(propertyId));
                }
                BooleanProperty property = new BooleanProperty(propertyId, defaultValue);
                EntityUtils.registerProperty(identifier, property);
                return property;
            }

            public <E extends Enum<E>> EnumProperty<E> registerEnumProperty(@NonNull Identifier identifier, @NonNull Identifier propertyId, @NonNull Class<E> enumClass, @Nullable E defaultValue) {
                Objects.requireNonNull(identifier);
                Objects.requireNonNull(propertyId);
                Objects.requireNonNull(enumClass);
                if (propertyId.vanilla()) {
                    throw new IllegalArgumentException("Cannot register custom property in vanilla namespace! " + String.valueOf(propertyId));
                }
                EnumProperty<E> property = new EnumProperty<E>(propertyId, enumClass, defaultValue == null ? ((Enum[])enumClass.getEnumConstants())[0] : defaultValue);
                EntityUtils.registerProperty(identifier, property);
                return property;
            }

            @Override
            public GeyserStringEnumProperty registerEnumProperty(@NonNull Identifier identifier, @NonNull Identifier propertyId, @NonNull List<String> values, @Nullable String defaultValue) {
                Objects.requireNonNull(identifier);
                Objects.requireNonNull(propertyId);
                Objects.requireNonNull(values);
                if (propertyId.vanilla()) {
                    throw new IllegalArgumentException("Cannot register custom property in vanilla namespace! " + String.valueOf(propertyId));
                }
                StringEnumProperty property = new StringEnumProperty(propertyId, values, defaultValue);
                EntityUtils.registerProperty(identifier, property);
                return property;
            }

            @Override
            public Collection<GeyserEntityProperty<?>> properties(@NonNull Identifier identifier) {
                Objects.requireNonNull(identifier);
                BedrockEntityDefinition definition = (BedrockEntityDefinition)Registries.BEDROCK_ENTITY_DEFINITIONS.get(identifier);
                if (definition == null) {
                    throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(identifier));
                }
                return List.copyOf(definition.registeredProperties().getProperties());
            }
        });
        for (BedrockEntityDefinition definition : ((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).values()) {
            if (definition.registeredProperties().isEmpty()) continue;
            ((Set)Registries.BEDROCK_ENTITY_PROPERTIES.get()).add(definition.registeredProperties().toNbtMap(definition.identifier().toString()));
        }
    }

    private static <T> void registerProperty(Identifier entityType, PropertyType<T, ?> property) {
        BedrockEntityDefinition definition = (BedrockEntityDefinition)Registries.BEDROCK_ENTITY_DEFINITIONS.get(entityType);
        if (definition == null) {
            throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(entityType));
        }
        definition.registeredProperties().add(entityType.toString(), property);
    }

    private EntityUtils() {
    }
}

