/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ShowCreditsPacket;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.ClientCommand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.EnterCreditsValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.RainStrengthValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.RespawnScreenValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.ThunderStrengthValue;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundGameEventPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientCommandPacket;

@Translator(packet=ClientboundGameEventPacket.class)
public class JavaGameEventTranslator
extends PacketTranslator<ClientboundGameEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundGameEventPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        switch (packet.getNotification()) {
            case START_RAINING: {
                session.updateRain(0.0f);
                break;
            }
            case STOP_RAINING: {
                session.updateRain(1.0f);
                break;
            }
            case RAIN_LEVEL_CHANGE: {
                float rainStrength = ((RainStrengthValue)packet.getValue()).getStrength();
                session.updateRain(rainStrength);
                break;
            }
            case THUNDER_LEVEL_CHANGE: {
                float thunderStrength = ((ThunderStrengthValue)packet.getValue()).getStrength();
                session.updateThunder(thunderStrength);
                break;
            }
            case CHANGE_GAME_MODE: {
                GameMode gameMode = (GameMode)packet.getValue();
                SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
                playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(gameMode).ordinal());
                session.sendUpstreamPacket(playerGameTypePacket);
                session.setGameMode(gameMode);
                session.sendAdventureSettings();
                if (session.getPlayerEntity().isOnGround() && gameMode == GameMode.SPECTATOR) {
                    MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
                    movePlayerPacket.setRuntimeEntityId(entity.geyserId());
                    movePlayerPacket.setPosition(entity.bedrockPosition());
                    movePlayerPacket.setRotation(entity.getBedrockRotation());
                    movePlayerPacket.setOnGround(false);
                    movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
                    movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
                    session.sendUpstreamPacket(movePlayerPacket);
                }
                PlayerInventoryTranslator.updateCraftingGrid(session, session.getPlayerInventory());
                break;
            }
            case WIN_GAME: {
                switch ((EnterCreditsValue)packet.getValue()) {
                    case SEEN_BEFORE: {
                        ServerboundClientCommandPacket javaRespawnPacket = new ServerboundClientCommandPacket(ClientCommand.RESPAWN);
                        session.sendDownstreamGamePacket(javaRespawnPacket);
                        break;
                    }
                    case FIRST_TIME: {
                        ShowCreditsPacket showCreditsPacket = new ShowCreditsPacket();
                        showCreditsPacket.setStatus(ShowCreditsPacket.Status.START_CREDITS);
                        showCreditsPacket.setRuntimeEntityId(entity.geyserId());
                        session.sendUpstreamPacket(showCreditsPacket);
                    }
                }
                break;
            }
            case GUARDIAN_ELDER_EFFECT: {
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setType(EntityEventType.ELDER_GUARDIAN_CURSE);
                eventPacket.setData(0);
                eventPacket.setRuntimeEntityId(entity.geyserId());
                session.sendUpstreamPacket(eventPacket);
                break;
            }
            case IMMEDIATE_RESPAWN: {
                GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
                gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", packet.getValue() == RespawnScreenValue.IMMEDIATE_RESPAWN));
                session.sendUpstreamPacket(gamerulePacket);
                break;
            }
            case NO_RESPAWN_BLOCK_AVAILABLE: {
                session.sendMessage(MinecraftLocale.getLocaleString("block.minecraft.spawn.not_valid", session.locale()));
                break;
            }
            case PLAY_ARROW_HIT_SOUND: {
                PlaySoundPacket arrowSoundPacket = new PlaySoundPacket();
                arrowSoundPacket.setSound("random.orb");
                arrowSoundPacket.setPitch(0.5f);
                arrowSoundPacket.setVolume(0.5f);
                arrowSoundPacket.setPosition(entity.bedrockPosition());
                session.sendUpstreamPacket(arrowSoundPacket);
                break;
            }
        }
    }
}

