/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.level.JavaLevelParticlesTranslator;
import org.geysermc.geyser.util.SoundUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundExplodePacket;

@Translator(packet=ClientboundExplodePacket.class)
public class JavaExplodeTranslator
extends PacketTranslator<ClientboundExplodePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundExplodePacket packet) {
        Vector3f vector = packet.getCenter().toFloat();
        LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
        levelEventPacket.setType(LevelEvent.PARTICLE_BLOCK_EXPLOSION);
        NbtMapBuilder builder = NbtMap.builder();
        builder.putFloat("originX", (float)packet.getCenter().getX());
        builder.putFloat("originY", (float)packet.getCenter().getY());
        builder.putFloat("originZ", (float)packet.getCenter().getZ());
        Function<Vector3f, BedrockPacket> particleCreator = JavaLevelParticlesTranslator.createParticle(session, packet.getExplosionParticle());
        if (particleCreator != null) {
            session.sendUpstreamPacket(particleCreator.apply(vector));
        }
        levelEventPacket.setTag(builder.build());
        session.sendUpstreamPacket(levelEventPacket);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        float pitch = (1.0f + (random.nextFloat() - random.nextFloat()) * 0.2f) * 0.7f;
        SoundUtils.playSound(session, packet.getExplosionSound(), vector, 4.0f, pitch);
        if (packet.getPlayerKnockback() != null) {
            SessionPlayerEntity entity = session.getPlayerEntity();
            entity.setMotion(entity.getMotion().add(packet.getPlayerKnockback().toFloat()));
            SetEntityMotionPacket motionPacket = new SetEntityMotionPacket();
            motionPacket.setRuntimeEntityId(entity.geyserId());
            motionPacket.setMotion(entity.getMotion());
            session.sendUpstreamPacket(motionPacket);
        }
    }
}

