/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Equipment;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEquipmentPacket;

@Translator(packet=ClientboundSetEquipmentPacket.class)
public class JavaSetEquipmentTranslator
extends PacketTranslator<ClientboundSetEquipmentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEquipmentPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            session.getGeyser().getLogger().debug("Attempted to add armor to a non-living entity (" + String.valueOf(entity.definition().identifier()) + ").");
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean armorUpdated = false;
        boolean mainHandUpdated = false;
        boolean offHandUpdated = false;
        block10: for (Equipment equipment : packet.getEquipment()) {
            GeyserItemStack stack = GeyserItemStack.from(equipment.getItem());
            switch (equipment.getSlot()) {
                case HELMET: {
                    ResolvableProfile profile = stack.getComponent(DataComponentTypes.PROFILE);
                    if (livingEntity instanceof PlayerEntity && stack.is(Items.PLAYER_HEAD) && profile != null) {
                        FakeHeadProvider.setHead(session, (PlayerEntity)livingEntity, profile);
                    } else {
                        FakeHeadProvider.restoreOriginalSkin(session, livingEntity);
                    }
                    livingEntity.setHelmet(stack);
                    armorUpdated = true;
                    continue block10;
                }
                case CHESTPLATE: {
                    livingEntity.setChestplate(stack);
                    armorUpdated = true;
                    continue block10;
                }
                case BODY: {
                    livingEntity.setBody(stack);
                    armorUpdated = true;
                    continue block10;
                }
                case LEGGINGS: {
                    livingEntity.setLeggings(stack);
                    armorUpdated = true;
                    continue block10;
                }
                case BOOTS: {
                    livingEntity.setBoots(stack);
                    armorUpdated = true;
                    continue block10;
                }
                case SADDLE: {
                    livingEntity.setSaddle(stack);
                    continue block10;
                }
                case MAIN_HAND: {
                    livingEntity.setHand(stack);
                    mainHandUpdated = true;
                    continue block10;
                }
                case OFF_HAND: {
                    livingEntity.setOffhand(stack);
                    offHandUpdated = true;
                }
            }
        }
        if (armorUpdated) {
            livingEntity.updateArmor();
        }
        if (mainHandUpdated) {
            livingEntity.updateMainHand();
        }
        if (offHandUpdated) {
            livingEntity.updateOffHand();
        }
    }
}

