/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.level.EffectType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MobEffectPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundRemoveMobEffectPacket;

@Translator(packet=ClientboundRemoveMobEffectPacket.class)
public class JavaRemoveMobEffectTranslator
extends PacketTranslator<ClientboundRemoveMobEffectPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRemoveMobEffectPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        if (entity == session.getPlayerEntity()) {
            session.getEffectCache().removeEffect(packet.getEffect());
        } else if (entity instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)entity);
            clientVehicle.getVehicleComponent().removeEffect(packet.getEffect());
        }
        MobEffectPacket mobEffectPacket = new MobEffectPacket();
        mobEffectPacket.setEvent(MobEffectPacket.Event.REMOVE);
        mobEffectPacket.setRuntimeEntityId(entity.geyserId());
        mobEffectPacket.setEffectId(EffectType.fromJavaEffect(packet.getEffect()).getBedrockId());
        session.sendUpstreamPacket(mobEffectPacket);
    }
}

