/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^chest$", passDefaultBoxes=true)
public class ChestCollision
extends BlockCollision {
    public ChestCollision(BlockState state, BoundingBox[] boxes) {
        super(boxes);
    }

    @Override
    public void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        super.correctPosition(session, x, y, z, playerCollision);
        SessionPlayerEntity player = session.getPlayerEntity();
        if (!player.isCollidingVertically()) {
            return;
        }
        double collisionExpansion = 2.0E-5;
        playerCollision.setSizeY(playerCollision.getSizeY() + 2.0E-5);
        double beforeYVelocity = player.getLastTickEndVelocity().getY();
        if (beforeYVelocity > 0.0 || playerCollision.getMin(Axis.Y) - (double)player.position().getY() > 0.0 || this.checkIntersection(x, y, z, playerCollision)) {
            playerCollision.setSizeY(playerCollision.getSizeX() - 2.0E-5);
            return;
        }
        playerCollision.setSizeY(playerCollision.getSizeX() - 2.0E-5);
        BoundingBox previous = playerCollision.clone();
        previous.setMiddleX(player.position().getX());
        previous.setMiddleY((double)player.position().getY() + playerCollision.getSizeY() / 2.0);
        previous.setMiddleZ(player.position().getZ());
        double yVelocity = Math.max(beforeYVelocity, this.computeCollisionOffset(x, y, z, previous, Axis.Y, beforeYVelocity));
        if (Math.abs(beforeYVelocity - yVelocity) <= 1.0E-5 || yVelocity > 1.0E-5) {
            return;
        }
        previous.translate(0.0, yVelocity, 0.0);
        playerCollision.setMiddleY(previous.getMiddleY());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChestCollision)) {
            return false;
        }
        ChestCollision other = (ChestCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChestCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

