/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.transformer;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.EnumMap;
import java.util.Map;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.transformer.EntityDataTransformer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;

public final class FlagTransformer
implements EntityDataTransformer<Long, EnumMap<EntityFlag, Boolean>> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(FlagTransformer.class);
    private final TypeMap<EntityFlag> typeMap;
    private final int index;

    @Override
    public Long serialize(BedrockCodecHelper helper, EntityDataMap map, EnumMap<EntityFlag, Boolean> flags) {
        long value = 0L;
        int lower = this.index * 64;
        int upper = lower + 64;
        boolean exists = false;
        for (Map.Entry<EntityFlag, Boolean> entry : flags.entrySet()) {
            int flagIndex;
            EntityFlag flag = entry.getKey();
            Boolean data = entry.getValue();
            if (data == null || (flagIndex = this.typeMap.getId(flag)) < lower || flagIndex >= upper) continue;
            exists = true;
            if (!data.booleanValue()) continue;
            value |= 1L << (flagIndex & 0x3F);
        }
        if (exists) {
            return value;
        }
        return null;
    }

    @Override
    public EnumMap<EntityFlag, Boolean> deserialize(BedrockCodecHelper helper, EntityDataMap map, Long value) {
        EnumMap<EntityFlag, Boolean> flags = map.getOrCreateFlags();
        int lower = this.index * 64;
        int upper = lower + 64;
        for (int i = lower; i < upper; ++i) {
            boolean set;
            int idx = i & 0x3F;
            EntityFlag flag = this.typeMap.getTypeUnsafe(i);
            boolean bl = set = (value & 1L << idx) != 0L;
            if (flag == null) {
                if (!set) continue;
                log.debug("Unknown entity flag set to true detected with index {}", (Object)i);
                continue;
            }
            if (set) {
                flags.put(flag, true);
                continue;
            }
            flags.put(flag, false);
        }
        return flags;
    }

    public FlagTransformer(TypeMap<EntityFlag> typeMap, int index) {
        this.typeMap = typeMap;
        this.index = index;
    }
}

