/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe;

import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.TaggedCraftingData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;

public class FurnaceRecipeData
implements TaggedCraftingData {
    private final CraftingDataType type;
    private final int inputId;
    private final int inputData;
    private final ItemData result;
    private final String tag;

    public boolean hasData() {
        return this.type == CraftingDataType.FURNACE_DATA;
    }

    public static FurnaceRecipeData of(CraftingDataType type, int inputId, int inputData, ItemData result, String tag) {
        Preconditions.checkArgument(type == CraftingDataType.FURNACE || type == CraftingDataType.FURNACE_DATA, "type must be FURNACE or FURNACE_DATA");
        return new FurnaceRecipeData(type, inputId, inputData, result, tag);
    }

    public static FurnaceRecipeData of(int inputId, ItemData result, String tag) {
        return new FurnaceRecipeData(CraftingDataType.FURNACE, inputId, -1, result, tag);
    }

    public static FurnaceRecipeData of(int inputId, int inputData, ItemData result, String tag) {
        return new FurnaceRecipeData(CraftingDataType.FURNACE_DATA, inputId, inputData, result, tag);
    }

    @Override
    public CraftingDataType getType() {
        return this.type;
    }

    public int getInputId() {
        return this.inputId;
    }

    public int getInputData() {
        return this.inputData;
    }

    public ItemData getResult() {
        return this.result;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return "FurnaceRecipeData(type=" + (Object)((Object)this.getType()) + ", inputId=" + this.getInputId() + ", inputData=" + this.getInputData() + ", result=" + this.getResult() + ", tag=" + this.getTag() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FurnaceRecipeData)) {
            return false;
        }
        FurnaceRecipeData other = (FurnaceRecipeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputId() != other.getInputId()) {
            return false;
        }
        if (this.getInputData() != other.getInputData()) {
            return false;
        }
        CraftingDataType this$type = this.getType();
        CraftingDataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ItemData this$result = this.getResult();
        ItemData other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FurnaceRecipeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInputId();
        result = result * 59 + this.getInputData();
        CraftingDataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ItemData $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    private FurnaceRecipeData(CraftingDataType type, int inputId, int inputData, ItemData result, String tag) {
        this.type = type;
        this.inputId = inputId;
        this.inputData = inputData;
        this.result = result;
        this.tag = tag;
    }
}

