/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.RakServerChannel;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.config.RakServerMetrics;

public class RakServerRateLimiter
extends SimpleChannelInboundHandler<DatagramPacket> {
    public static final String NAME = "rak-server-rate-limiter";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakServerRateLimiter.class);
    private final RakServerChannel channel;
    private final ConcurrentHashMap<InetAddress, AtomicInteger> rateLimitMap = new ConcurrentHashMap();
    private final Map<InetAddress, Long> blockedConnections = new ConcurrentHashMap<InetAddress, Long>();
    private final Collection<InetAddress> exceptions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong globalCounter = new AtomicLong(0L);
    private ScheduledFuture<?> tickFuture;
    private ScheduledFuture<?> blockedTickFuture;

    public RakServerRateLimiter(RakServerChannel channel) {
        this.channel = channel;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.tickFuture = ctx.channel().eventLoop().scheduleAtFixedRate(this::onRakTick, 10L, 10L, TimeUnit.MILLISECONDS);
        this.blockedTickFuture = ctx.channel().eventLoop().scheduleAtFixedRate(this::onBlockedTick, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.tickFuture.cancel(false);
        this.blockedTickFuture.cancel(true);
        this.rateLimitMap.clear();
    }

    protected void onRakTick() {
        this.rateLimitMap.clear();
        this.globalCounter.set(0L);
    }

    protected void onBlockedTick() {
        long currTime = System.currentTimeMillis();
        RakServerMetrics metrics = this.channel.config().getMetrics();
        Iterator<Map.Entry<InetAddress, Long>> iterator = this.blockedConnections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InetAddress, Long> entry = iterator.next();
            if (entry.getValue() == 0L || currTime <= entry.getValue()) continue;
            iterator.remove();
            log.info("Unblocked address {}", (Object)entry.getKey());
            if (metrics == null) continue;
            metrics.addressUnblocked(entry.getKey());
        }
    }

    public boolean blockAddress(InetAddress address, long time, TimeUnit unit) {
        if (this.exceptions.contains(address)) {
            return false;
        }
        long millis = unit.toMillis(time);
        this.blockedConnections.put(address, System.currentTimeMillis() + millis);
        if (this.channel.config().getMetrics() != null) {
            this.channel.config().getMetrics().addressBlocked(address);
        }
        return true;
    }

    public void unblockAddress(InetAddress address) {
        if (this.blockedConnections.remove(address) == null) {
            return;
        }
        log.info("Unblocked address {}", (Object)address);
        if (this.channel.config().getMetrics() != null) {
            this.channel.config().getMetrics().addressUnblocked(address);
        }
    }

    public boolean isAddressBlocked(InetAddress address) {
        return this.blockedConnections.containsKey(address);
    }

    public void addException(InetAddress address) {
        this.exceptions.add(address);
    }

    public void removeException(InetAddress address) {
        this.exceptions.remove(address);
    }

    public Collection<InetAddress> getExceptions() {
        return Collections.unmodifiableCollection(this.exceptions);
    }

    protected int getAddressMaxPacketCount(InetAddress address) {
        return this.channel.config().getPacketLimit();
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket datagram) throws Exception {
        if (this.globalCounter.incrementAndGet() > (long)this.channel.config().getGlobalPacketLimit()) {
            if (log.isTraceEnabled()) {
                log.trace("[{}] Dropped incoming packet because global packet limit was reached: {}", (Object)datagram.sender(), (Object)this.globalCounter.get());
            }
            return;
        }
        InetAddress address = ((InetSocketAddress)datagram.sender()).getAddress();
        if (this.blockedConnections.containsKey(address)) {
            return;
        }
        AtomicInteger counter = this.rateLimitMap.computeIfAbsent(address, a -> new AtomicInteger());
        if (counter.incrementAndGet() > this.getAddressMaxPacketCount(address) && this.blockAddress(address, 10L, TimeUnit.SECONDS)) {
            log.warn("[{}] Blocked because packet limit was reached", (Object)address);
        } else {
            ctx.fireChannelRead((Object)datagram.retain());
        }
    }
}

