/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.waypoint;

import java.awt.Color;
import java.util.Optional;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.waypoint.GeyserWaypoint;
import org.geysermc.geyser.session.cache.waypoint.TickingWaypoint;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.AzimuthWaypointData;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.WaypointData;

public class AzimuthWaypoint
extends GeyserWaypoint
implements TickingWaypoint {
    private static final float WAYPOINT_DISTANCE = 1000.0f;
    private float angle = 0.0f;

    public AzimuthWaypoint(GeyserSession session, Optional<PlayerEntity> player, Color color) {
        super(session, player, color);
    }

    @Override
    public void setData(WaypointData data) {
        if (data instanceof AzimuthWaypointData) {
            AzimuthWaypointData azimuthData = (AzimuthWaypointData)data;
            this.angle = azimuthData.angle();
            this.updatePosition();
        } else {
            this.session.getGeyser().getLogger().warning("Received incorrect waypoint data " + String.valueOf(data.getClass()) + " for azimuth waypoint");
        }
    }

    @Override
    public void tick() {
        this.updatePosition();
        this.sendLocationPacket(false);
    }

    private void updatePosition() {
        Vector3f playerPosition = this.session.getPlayerEntity().position();
        float dx = (float)(-(Math.sin(this.angle) * 1000.0));
        float dz = (float)(Math.cos(this.angle) * 1000.0);
        this.position = Vector3f.from((float)(playerPosition.getX() + dx), (float)playerPosition.getY(), (float)(playerPosition.getZ() + dz));
    }
}

