/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.java.JavaAuthManager;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.service.impl.DeviceCodeMsaAuthService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;

public class PendingMicrosoftAuthentication {
    public static final HttpClient AUTH_CLIENT = MinecraftAuth.createHttpClient();
    private boolean storeServerInformation = false;
    private final LoadingCache<String, AuthenticationTask> authentications;

    public PendingMicrosoftAuthentication(final int timeoutSeconds) {
        this.authentications = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AuthenticationTask>(){

            public AuthenticationTask load(@NonNull String userKey) {
                return PendingMicrosoftAuthentication.this.storeServerInformation ? new ProxyAuthenticationTask(userKey, timeoutSeconds) : new AuthenticationTask(userKey, timeoutSeconds);
            }
        });
    }

    public AuthenticationTask getTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.getIfPresent((Object)userKey);
    }

    public AuthenticationTask getOrCreateTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.get((Object)userKey);
    }

    public void setStoreServerInformation() {
        this.storeServerInformation = true;
    }

    public class AuthenticationTask {
        private static final Executor DELAYED_BY_ONE_SECOND = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        private final String userKey;
        private final int timeoutSec;
        private CompletableFuture<JavaAuthManager> authentication;

        private AuthenticationTask(String userKey, int timeoutSec) {
            this.userKey = userKey;
            this.timeoutSec = timeoutSec;
        }

        public void resetRunningFlow() {
            if (this.authentication == null) {
                return;
            }
            this.authentication.cancel(true);
        }

        public void cleanup() {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Cleaning up authentication task for " + this.userKey);
            }
            PendingMicrosoftAuthentication.this.authentications.invalidate((Object)this.userKey);
        }

        public CompletableFuture<JavaAuthManager> performLoginAttempt(boolean offlineAccess, Consumer<MsaDeviceCode> deviceCodeConsumer) {
            MsaApplicationConfig applicationConfig = GeyserImpl.OAUTH_CONFIG.withScope(offlineAccess ? "XboxLive.signin XboxLive.offline_access" : "XboxLive.signin");
            DeviceCodeMsaAuthService authService = new DeviceCodeMsaAuthService(AUTH_CLIENT, applicationConfig, deviceCodeConsumer, this.timeoutSec * 1000);
            this.authentication = CompletableFuture.supplyAsync(() -> {
                try {
                    MsaToken msaToken = authService.acquireToken();
                    JavaAuthManager authManager = JavaAuthManager.create((HttpClient)AUTH_CLIENT).msaApplicationConfig(applicationConfig).login(msaToken);
                    authManager.getMinecraftToken().refresh();
                    authManager.getMinecraftProfile().refresh();
                    return authManager;
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, DELAYED_BY_ONE_SECOND).whenComplete((r, ex) -> CompletableFuture.delayedExecutor(this.timeoutSec, TimeUnit.SECONDS).execute(this::cleanup));
            return this.authentication;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{userKey='" + this.userKey + "'}";
        }

        @Generated
        public CompletableFuture<JavaAuthManager> getAuthentication() {
            return this.authentication;
        }
    }

    public final class ProxyAuthenticationTask
    extends AuthenticationTask {
        private String server;
        private int port;

        private ProxyAuthenticationTask(String userKey, int timeoutSec) {
            super(userKey, timeoutSec);
        }

        @Generated
        public String getServer() {
            return this.server;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public void setServer(String server) {
            this.server = server;
        }

        @Generated
        public void setPort(int port) {
            this.port = port;
        }
    }
}

