/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v844.Bedrock_v844;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v859.Bedrock_v859;

public final class TagRegistryPopulator {
    private static final Gson GSON = new GsonBuilder().create();

    public static void populate() {
        Hash.Strategy<int[]> hashStrategy = new Hash.Strategy<int[]>(){

            public int hashCode(int[] o) {
                return Arrays.hashCode(o);
            }

            public boolean equals(int[] a, int[] b) {
                return Arrays.equals(a, b);
            }
        };
        List<ObjectIntPair> paletteVersions = List.of(ObjectIntPair.of((Object)"1_21_110", (int)Bedrock_v844.CODEC.getProtocolVersion()), ObjectIntPair.of((Object)"1_21_120", (int)Bedrock_v859.CODEC.getProtocolVersion()));
        Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        for (ObjectIntPair palette : paletteVersions) {
            Map bedrockTags;
            ItemMappings mappings = Registries.ITEMS.forVersion(palette.rightInt());
            try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/item_tags.%s.json", palette.left()));){
                bedrockTags = (Map)GSON.fromJson((Reader)new InputStreamReader(stream), type);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            Object2ObjectOpenCustomHashMap javaItemsToBedrockTag = new Object2ObjectOpenCustomHashMap((Hash.Strategy)hashStrategy);
            for (Map.Entry entry : bedrockTags.entrySet()) {
                List value = (List)entry.getValue();
                if (value.isEmpty() || value.size() == 1) continue;
                IntArrayList javaNetworkIds = new IntArrayList(value.size());
                for (int i = 0; i < value.size(); ++i) {
                    String bedrockIdentifier = (String)value.get(i);
                    Item javaItem = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(bedrockIdentifier);
                    if (javaItem == null) {
                        for (ItemMapping mapping : mappings.getItems()) {
                            if (!mapping.getBedrockIdentifier().equals(bedrockIdentifier)) continue;
                            javaItem = mapping.getJavaItem();
                            break;
                        }
                    }
                    if (javaItem == null) continue;
                    javaNetworkIds.add(javaItem.javaId());
                }
                int[] javaNetworkIdArray = javaNetworkIds.toIntArray();
                Arrays.sort(javaNetworkIdArray);
                javaItemsToBedrockTag.put((Object)javaNetworkIdArray, (Object)((String)entry.getKey()));
            }
            javaItemsToBedrockTag.trim();
            Registries.TAGS.register(palette.rightInt(), (Object2ObjectMap<int[], String>)javaItemsToBedrockTag);
        }
    }
}

