/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.api.entity.data.GeyserListEntityDataType;
import org.geysermc.geyser.api.entity.data.types.Hitbox;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.impl.entity.GeyserEntityDataImpl;
import org.geysermc.geyser.impl.entity.HitboxImpl;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;

public class GeyserListEntityDataImpl<ListType>
extends GeyserEntityDataImpl<List<ListType>>
implements GeyserListEntityDataType<ListType> {
    public static Map<String, GeyserListEntityDataImpl<?>> TYPES = new Object2ObjectOpenHashMap();
    private final Class<ListType> listTypeClass;

    public GeyserListEntityDataImpl(Class<ListType> typeClass, String name, BiConsumer<Entity, List<ListType>> consumer, Function<Entity, List<ListType>> getter) {
        super(List.class, name, consumer, getter);
        this.listTypeClass = typeClass;
    }

    @Override
    public @NonNull Class<ListType> listEntryClass() {
        return this.listTypeClass;
    }

    public static GeyserListEntityDataImpl<?> lookup(Class<?> clazz, Class<?> listTypeClass, String name) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(listTypeClass);
        Objects.requireNonNull(name);
        if (clazz != List.class) {
            throw new IllegalStateException("Cannot look up list entity data for " + String.valueOf(clazz) + " and " + String.valueOf(listTypeClass) + " for " + name);
        }
        GeyserListEntityDataImpl<?> type = TYPES.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown entity data type: " + name);
        }
        if (type.listEntryClass() == listTypeClass) {
            return TYPES.get(name);
        }
        throw new IllegalArgumentException("Unknown entity data type: " + name);
    }

    static {
        TYPES.put("hitboxes", new GeyserListEntityDataImpl<Hitbox>(Hitbox.class, "hitboxes", (entity, hitboxes) -> entity.getDirtyMetadata().put(EntityDataTypes.HITBOX, HitboxImpl.toNbtMap(hitboxes)), entity -> HitboxImpl.fromMetaData((NbtMap)entity.getMetadata().get(EntityDataTypes.HITBOX))));
    }
}

