/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster.raid;

import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.monster.raid.AbstractIllagerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public class PillagerEntity
extends AbstractIllagerEntity {
    public PillagerEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setChargingCrossbow(BooleanEntityMetadata entityMetadata) {
        boolean charging = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.CHARGING, charging);
        this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, charging ? (byte)64 : 0);
    }

    @Override
    public void updateMainHand() {
        this.updateCrossbow();
        super.updateMainHand();
    }

    @Override
    public void updateOffHand() {
        this.updateCrossbow();
        super.updateOffHand();
    }

    protected void updateCrossbow() {
        GeyserItemStack activeCrossbow = null;
        if (this.getMainHandItem().is(Items.CROSSBOW)) {
            activeCrossbow = this.getMainHandItem();
        } else if (this.getOffHandItem().is(Items.CROSSBOW)) {
            activeCrossbow = this.getOffHandItem();
        }
        if (activeCrossbow != null) {
            if (activeCrossbow.getComponent(DataComponentTypes.CHARGED_PROJECTILES) != null) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)127);
                this.setFlag(EntityFlag.CHARGING, false);
                this.setFlag(EntityFlag.CHARGED, true);
                this.setFlag(EntityFlag.USING_ITEM, true);
            } else if (this.getFlag(EntityFlag.CHARGED)) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)0);
                this.setFlag(EntityFlag.CHARGED, false);
                this.setFlag(EntityFlag.USING_ITEM, false);
            }
        }
        this.updateBedrockMetadata();
    }
}

