/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.concurrent.ThreadLocalRandom;
import org.cloudburstmc.math.GenericMath;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class WardenEntity
extends MonsterEntity
implements Tickable {
    private int heartBeatDelay = 40;
    private int tickCount;
    private int sonicBoomTickDuration;

    public WardenEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.HEARTBEAT_INTERVAL_TICKS, this.heartBeatDelay);
    }

    @Override
    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.DIGGING, pose == Pose.DIGGING);
        this.setFlag(EntityFlag.EMERGING, pose == Pose.EMERGING);
        this.setFlag(EntityFlag.ROARING, pose == Pose.ROARING);
        this.setFlag(EntityFlag.SNIFFING, pose == Pose.SNIFFING);
        super.setPose(pose);
    }

    public void setAngerLevel(IntEntityMetadata entityMetadata) {
        float anger = (float)entityMetadata.getPrimitiveValue() / 80.0f;
        this.heartBeatDelay = 40 - GenericMath.floor((float)(MathUtils.clamp(anger, 0.0f, 1.0f) * 30.0f));
        this.dirtyMetadata.put(EntityDataTypes.HEARTBEAT_INTERVAL_TICKS, this.heartBeatDelay);
    }

    @Override
    public void tick() {
        super.tick();
        if (++this.tickCount % this.heartBeatDelay == 0 && !this.silent) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            PlaySoundPacket packet = new PlaySoundPacket();
            packet.setSound("mob.warden.heartbeat");
            packet.setPosition(this.bedrockPosition());
            packet.setPitch((random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            packet.setVolume(1.0f);
            this.session.sendUpstreamPacket(packet);
        }
        if (this.sonicBoomTickDuration > 0) {
            --this.sonicBoomTickDuration;
            if (this.sonicBoomTickDuration == 0) {
                this.setFlag(EntityFlag.SONIC_BOOM, false);
                this.updateBedrockMetadata();
            }
        }
    }

    public void onSonicBoom() {
        this.setFlag(EntityFlag.SONIC_BOOM, true);
        this.updateBedrockMetadata();
        this.sonicBoomTickDuration = 60;
    }
}

