/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.GolemEntity;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;

public class ShulkerEntity
extends GolemEntity {
    public ShulkerEntity(EntitySpawnContext context) {
        super(context);
        this.setFlag(EntityFlag.BRIBED, true);
    }

    @Override
    public boolean shouldLerp() {
        return false;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, 16);
        this.setFlag(EntityFlag.COLLIDABLE, true);
        this.setFlag(EntityFlag.RENDER_WHEN_INVISIBLE, true);
    }

    public void setAttachedFace(EntityMetadata<Direction, ?> entityMetadata) {
        Direction direction = entityMetadata.getValue();
        this.dirtyMetadata.put(EntityDataTypes.SHULKER_ATTACH_FACE, direction.ordinal());
    }

    public void setShulkerHeight(ByteEntityMetadata entityMetadata) {
        byte height = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityDataTypes.SHULKER_PEEK_AMOUNT, Integer.valueOf(height));
    }

    public void setShulkerColor(ByteEntityMetadata entityMetadata) {
        byte color = entityMetadata.getPrimitiveValue();
        if (color == 16) {
            this.dirtyMetadata.put(EntityDataTypes.VARIANT, 16);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.VARIANT, Math.abs(color - 15));
        }
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }
}

