/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class CreeperEntity
extends MonsterEntity {
    private boolean ignitedByFlintAndSteel = false;

    public CreeperEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setSwelling(IntEntityMetadata entityMetadata) {
        if (!this.ignitedByFlintAndSteel) {
            this.setFlag(EntityFlag.IGNITED, entityMetadata.getPrimitiveValue() == 1);
        }
    }

    public void setIgnited(BooleanEntityMetadata entityMetadata) {
        this.ignitedByFlintAndSteel = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.IGNITED, this.ignitedByFlintAndSteel);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(this.session, ItemTag.CREEPER_IGNITERS)) {
            return InteractiveTag.IGNITE_CREEPER;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(this.session, ItemTag.CREEPER_IGNITERS)) {
            this.session.playSoundEvent(SoundEvent.IGNITE, this.bedrockPosition());
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

