/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.farm.CowEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class MooshroomEntity
extends CowEntity {
    private boolean isBrown = false;

    public MooshroomEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setMooshroomVariant(IntEntityMetadata metadata) {
        this.isBrown = metadata.getPrimitiveValue() == 1;
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, metadata.getPrimitiveValue());
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.isBaby()) {
            if (itemInHand.is(Items.BOWL)) {
                return InteractiveTag.MOOSHROOM_MILK_STEW;
            }
            if (this.isAlive() && itemInHand.is(Items.SHEARS)) {
                return InteractiveTag.MOOSHROOM_SHEAR;
            }
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby && itemInHand.is(Items.BOWL)) {
            return InteractionResult.SUCCESS;
        }
        if (!isBaby && this.isAlive() && itemInHand.is(Items.SHEARS)) {
            return InteractionResult.SUCCESS;
        }
        if (this.isBrown && itemInHand.is(this.session, ItemTag.SMALL_FLOWERS)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

