/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;

public class AbstractArrowEntity
extends Entity {
    public AbstractArrowEntity(EntitySpawnContext context) {
        super(context);
        this.setFlag(EntityFlag.BRIBED, this.javaTypeDefinition.type().is(BuiltinEntityType.SPECTRAL_ARROW));
        this.setMotion(this.motion);
    }

    public void setArrowFlags(ByteEntityMetadata entityMetadata) {
        byte data = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.CRITICAL, (data & 1) == 1);
    }

    @Override
    public void setYaw(float yaw) {
    }

    @Override
    public void setPitch(float pitch) {
    }

    @Override
    public void setHeadYaw(float headYaw) {
    }

    @Override
    public void setMotion(Vector3f motion) {
        super.setMotion(motion);
        double horizontalSpeed = Math.sqrt(motion.getX() * motion.getX() + motion.getZ() * motion.getZ());
        this.setYaw((float)Math.toDegrees(Math.atan2(motion.getX(), motion.getZ())));
        this.setPitch((float)Math.toDegrees(Math.atan2(motion.getY(), horizontalSpeed)));
        this.setHeadYaw(this.getYaw());
    }
}

