/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.entity.EntityData;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.input.InputLocksFlag;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EmotePacket;

public class GeyserEntityData
implements EntityData {
    private final GeyserSession session;
    private final Set<UUID> movementLockOwners = new HashSet<UUID>();

    public GeyserEntityData(GeyserSession session) {
        this.session = session;
    }

    @Override
    public @NonNull CompletableFuture<@Nullable GeyserEntity> entityByJavaId(@NonNegative int javaId) {
        CompletableFuture<GeyserEntity> future = new CompletableFuture<GeyserEntity>();
        this.session.ensureInEventLoop(() -> future.complete(this.session.getEntityCache().getEntityByJavaId(javaId)));
        return future;
    }

    @Override
    public @Nullable GeyserEntity byJavaId(@NonNegative int javaId) {
        if (javaId < 0) {
            throw new IllegalArgumentException("entity id cannot be negative! (got: " + javaId + ")");
        }
        return this.session.getEntityCache().getEntityByJavaId(javaId);
    }

    @Override
    public @Nullable GeyserEntity byUuid(@NonNull UUID javaUuid) {
        Objects.requireNonNull(javaUuid, "javaUuid");
        return this.session.getEntityCache().getEntityByUuid(javaUuid);
    }

    @Override
    public @Nullable GeyserEntity byGeyserId(@NonNegative long geyserId) {
        if (geyserId < 0L) {
            throw new IllegalArgumentException("geyser entity id cannot be negative! (got: " + geyserId + ")");
        }
        return this.session.getEntityCache().getEntityByGeyserId(geyserId);
    }

    @Override
    public void showEmote(@NonNull GeyserPlayerEntity emoter, @NonNull String emoteId) {
        Objects.requireNonNull(emoter, "emoter must not be null!");
        Entity entity = (Entity)((Object)emoter);
        if (entity.getSession() != this.session) {
            throw new IllegalStateException("Given entity must be from this session!");
        }
        EmotePacket packet = new EmotePacket();
        packet.setRuntimeEntityId(entity.geyserId());
        packet.setXuid("");
        packet.setPlatformId("");
        packet.setEmoteId(emoteId);
        this.session.sendUpstreamPacket(packet);
    }

    @Override
    public @NonNull GeyserPlayerEntity playerEntity() {
        return this.session.getPlayerEntity();
    }

    @Override
    public boolean lockMovement(boolean lock, @NonNull UUID owner) {
        Objects.requireNonNull(owner, "owner must not be null!");
        if (lock) {
            this.movementLockOwners.add(owner);
        } else {
            this.movementLockOwners.remove(owner);
        }
        this.session.setLockInput(InputLocksFlag.MOVEMENT, this.isMovementLocked());
        this.session.updateInputLocks();
        return this.isMovementLocked();
    }

    @Override
    public boolean isMovementLocked() {
        return !this.movementLockOwners.isEmpty();
    }

    @Override
    public void switchHands() {
        this.session.requestOffhandSwap();
    }
}

