/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.entity.custom.CustomEntityDefinition;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.registry.Registries;

public record BedrockEntityDefinition(@NonNull Identifier identifier, @NonNull GeyserEntityProperties registeredProperties) implements GeyserEntityDefinition,
CustomEntityDefinition
{
    public static Builder builder() {
        return new Builder();
    }

    public static BedrockEntityDefinition ofVanilla(Identifier identifier) {
        return BedrockEntityDefinition.builder().identifier(identifier).build();
    }

    public static BedrockEntityDefinition getOrCreate(@NonNull Identifier identifier) {
        Objects.requireNonNull(identifier, "identifier");
        if (((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).containsKey(identifier)) {
            return (BedrockEntityDefinition)((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).get(identifier);
        }
        if (identifier.vanilla()) {
            throw new IllegalArgumentException("Cannot create custom entity in vanilla namespace! " + String.valueOf(identifier));
        }
        return BedrockEntityDefinition.builder().identifier(identifier).build();
    }

    @Override
    public List<GeyserEntityProperty<?>> properties() {
        if (this.registeredProperties.isEmpty()) {
            return List.of();
        }
        return List.copyOf(this.registeredProperties.getProperties());
    }

    @Override
    public boolean vanilla() {
        return this.identifier.vanilla();
    }

    @Override
    public boolean registered() {
        return ((Map)Registries.BEDROCK_ENTITY_DEFINITIONS.get()).containsKey(this.identifier);
    }

    public static class Builder {
        private Identifier identifier;
        protected GeyserEntityProperties.Builder propertiesBuilder;

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder properties(@Nullable GeyserEntityProperties.Builder propertiesBuilder) {
            this.propertiesBuilder = propertiesBuilder;
            return this;
        }

        BedrockEntityDefinition build() {
            return new BedrockEntityDefinition(this.identifier, this.propertiesBuilder != null ? this.propertiesBuilder.build() : new GeyserEntityProperties());
        }
    }
}

