/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ping.serverbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPingRequestPacket
implements MinecraftPacket {
    private final long pingTime;

    public ServerboundPingRequestPacket(ByteBuf in) {
        this.pingTime = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeLong(this.pingTime);
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPingRequestPacket)) {
            return false;
        }
        ServerboundPingRequestPacket other = (ServerboundPingRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingTime() == other.getPingTime();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPingRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingTime = this.getPingTime();
        result = result * 59 + (int)($pingTime >>> 32 ^ $pingTime);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPingRequestPacket(pingTime=" + this.getPingTime() + ")";
    }

    public @NonNull ServerboundPingRequestPacket withPingTime(long pingTime) {
        return this.pingTime == pingTime ? this : new ServerboundPingRequestPacket(pingTime);
    }

    public ServerboundPingRequestPacket(long pingTime) {
        this.pingTime = pingTime;
    }
}

