/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundMountScreenOpenPacket
implements MinecraftPacket {
    private final int containerId;
    private final int inventoryColumns;
    private final int entityId;

    public ClientboundMountScreenOpenPacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
        this.inventoryColumns = MinecraftTypes.readVarInt(in);
        this.entityId = in.readInt();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
        MinecraftTypes.writeVarInt(out, this.inventoryColumns);
        out.writeInt(this.entityId);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getInventoryColumns() {
        return this.inventoryColumns;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMountScreenOpenPacket)) {
            return false;
        }
        ClientboundMountScreenOpenPacket other = (ClientboundMountScreenOpenPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getInventoryColumns() != other.getInventoryColumns()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMountScreenOpenPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getInventoryColumns();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMountScreenOpenPacket(containerId=" + this.getContainerId() + ", inventoryColumns=" + this.getInventoryColumns() + ", entityId=" + this.getEntityId() + ")";
    }

    public @NonNull ClientboundMountScreenOpenPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundMountScreenOpenPacket(containerId, this.inventoryColumns, this.entityId);
    }

    public @NonNull ClientboundMountScreenOpenPacket withInventoryColumns(int inventoryColumns) {
        return this.inventoryColumns == inventoryColumns ? this : new ClientboundMountScreenOpenPacket(this.containerId, inventoryColumns, this.entityId);
    }

    public @NonNull ClientboundMountScreenOpenPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundMountScreenOpenPacket(this.containerId, this.inventoryColumns, entityId);
    }

    public ClientboundMountScreenOpenPacket(int containerId, int inventoryColumns, int entityId) {
        this.containerId = containerId;
        this.inventoryColumns = inventoryColumns;
        this.entityId = entityId;
    }
}

