/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundPlayerRotationPacket
implements MinecraftPacket {
    private final float yRot;
    private final boolean relativeY;
    private final float xRot;
    private final boolean relativeX;

    public ClientboundPlayerRotationPacket(ByteBuf in) {
        this.yRot = in.readFloat();
        this.relativeY = in.readBoolean();
        this.xRot = in.readFloat();
        this.relativeX = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeFloat(this.yRot);
        out.writeBoolean(this.relativeY);
        out.writeFloat(this.xRot);
        out.writeBoolean(this.relativeX);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getYRot() {
        return this.yRot;
    }

    public boolean isRelativeY() {
        return this.relativeY;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean isRelativeX() {
        return this.relativeX;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerRotationPacket)) {
            return false;
        }
        ClientboundPlayerRotationPacket other = (ClientboundPlayerRotationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (this.isRelativeY() != other.isRelativeY()) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        return this.isRelativeX() == other.isRelativeX();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerRotationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + (this.isRelativeY() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        result = result * 59 + (this.isRelativeX() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerRotationPacket(yRot=" + this.getYRot() + ", relativeY=" + this.isRelativeY() + ", xRot=" + this.getXRot() + ", relativeX=" + this.isRelativeX() + ")";
    }

    public @NonNull ClientboundPlayerRotationPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundPlayerRotationPacket(yRot, this.relativeY, this.xRot, this.relativeX);
    }

    public @NonNull ClientboundPlayerRotationPacket withRelativeY(boolean relativeY) {
        return this.relativeY == relativeY ? this : new ClientboundPlayerRotationPacket(this.yRot, relativeY, this.xRot, this.relativeX);
    }

    public @NonNull ClientboundPlayerRotationPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundPlayerRotationPacket(this.yRot, this.relativeY, xRot, this.relativeX);
    }

    public @NonNull ClientboundPlayerRotationPacket withRelativeX(boolean relativeX) {
        return this.relativeX == relativeX ? this : new ClientboundPlayerRotationPacket(this.yRot, this.relativeY, this.xRot, relativeX);
    }

    public ClientboundPlayerRotationPacket(float yRot, boolean relativeY, float xRot, boolean relativeX) {
        this.yRot = yRot;
        this.relativeY = relativeY;
        this.xRot = xRot;
        this.relativeX = relativeX;
    }
}

