/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.PluginMessageUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginFinishedPacket;

@Translator(packet=ClientboundLoginFinishedPacket.class)
public class JavaLoginFinishedTranslator
extends PacketTranslator<ClientboundLoginFinishedPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginFinishedPacket packet) {
        SessionPlayerEntity playerEntity = session.getPlayerEntity();
        AuthType remoteAuthType = session.remoteServer().authType();
        GameProfile profile = packet.getProfile();
        playerEntity.setUsername(profile.getName());
        playerEntity.uuid(profile.getId());
        session.getGeyser().getSessionManager().addSession(playerEntity.uuid(), session);
        if (remoteAuthType == AuthType.OFFLINE || playerEntity.uuid().getMostSignificantBits() == 0L) {
            SkinManager.handleBedrockSkin(playerEntity, session.getClientData());
        }
        if (remoteAuthType == AuthType.FLOODGATE) {
            session.getGeyser().getSkinUploader().uploadSkin(session);
        }
        session.setCertChainData(null);
        session.setToken(null);
        session.getClientData().setOriginalString(null);
        session.hasAcceptedCodeOfConduct(false);
        session.sendDownstreamPacket(new ServerboundCustomPayloadPacket(Key.key("brand"), PluginMessageUtils.getGeyserBrandData()), ProtocolState.CONFIGURATION);
        session.sendJavaClientSettings();
    }
}

