/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.TRIAL_SPAWNER})
public class TrialSpawnerBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        if (javaNbt == null) {
            return;
        }
        NbtMap entityData = javaNbt.getCompound("spawn_data").getCompound("entity");
        if (entityData.isEmpty()) {
            return;
        }
        NbtMapBuilder spawnData = NbtMap.builder();
        EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_IDENTIFIERS.get(entityData.getString("id"));
        if (definition != null && definition.defaultBedrockDefinition() != null) {
            spawnData.putString("TypeId", definition.defaultBedrockDefinition().identifier().toString());
        }
        spawnData.putInt("Weight", entityData.getInt("Size", 1));
        bedrockNbt.putCompound("spawn_data", spawnData.build());
    }
}

