/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.VanillaEntities;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.WallSkullBlock;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.mcprotocollib.auth.GameProfile;

public class SkullCache {
    private final int maxVisibleSkulls;
    private final boolean cullingEnabled;
    private final int skullRenderDistanceSquared;
    private final Map<Vector3i, Skull> skulls = new Object2ObjectOpenHashMap<Vector3i, Skull>();
    private final List<Skull> inRangeSkulls = new ArrayList<Skull>();
    private int totalSkullEntities = 0;
    private final GeyserSession session;
    private Vector3f lastPlayerPosition;

    public SkullCache(GeyserSession session) {
        this.session = session;
        this.maxVisibleSkulls = session.getGeyser().config().gameplay().maxVisibleCustomSkulls();
        this.cullingEnabled = this.maxVisibleSkulls != -1;
        int distance = Math.min(session.getGeyser().config().gameplay().customSkullRenderDistance(), 64);
        this.skullRenderDistanceSquared = distance * distance;
    }

    public Skull putSkull(Vector3i position, GameProfile resolved, BlockState blockState) {
        GameProfile.Property textures = resolved.getProperty("textures");
        if (textures != null) {
            return this.putSkull(position, resolved.getId(), textures.getValue(), blockState);
        }
        return null;
    }

    public Skull putSkull(Vector3i position, UUID uuid, String texturesProperty, BlockState blockState) {
        Skull skull;
        block14: {
            skull = this.skulls.computeIfAbsent(position, Skull::new);
            skull.uuid = uuid;
            if (!texturesProperty.equals(skull.texturesProperty)) {
                skull.texturesProperty = texturesProperty;
                skull.skinHash = null;
                try {
                    SkinManager.GameProfileData gameProfileData = SkinManager.GameProfileData.loadFromJson(texturesProperty);
                    if (gameProfileData != null && gameProfileData.skinUrl() != null) {
                        String skinUrl = gameProfileData.skinUrl();
                        skull.skinHash = skinUrl.substring(skinUrl.lastIndexOf(47) + 1);
                    } else {
                        this.session.getGeyser().getLogger().debug("Player skull with invalid Skin tag: " + String.valueOf(position) + " Textures: " + texturesProperty);
                    }
                }
                catch (IOException e) {
                    this.session.getGeyser().getLogger().debug("Player skull with invalid Skin tag: " + String.valueOf(position) + " Textures: " + texturesProperty);
                    if (!GeyserImpl.getInstance().config().debugMode()) break block14;
                    e.printStackTrace();
                }
            }
        }
        skull.blockState = blockState;
        skull.blockDefinition = this.translateCustomSkull(skull.skinHash, blockState);
        if (skull.blockDefinition != null) {
            this.reassignSkullEntity(skull);
            return skull;
        }
        if (skull.entity != null) {
            skull.entity.updateSkull(skull);
        } else {
            if (!this.cullingEnabled) {
                this.assignSkullEntity(skull);
                return skull;
            }
            if (this.lastPlayerPosition == null) {
                return skull;
            }
            skull.distanceSquared = position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
            if (skull.distanceSquared < this.skullRenderDistanceSquared) {
                int i = Collections.binarySearch(this.inRangeSkulls, skull, Comparator.comparingInt(Skull::getDistanceSquared));
                if (i < 0) {
                    i = -i - 1;
                }
                this.inRangeSkulls.add(i, skull);
                if (i < this.maxVisibleSkulls) {
                    if (this.inRangeSkulls.size() > this.maxVisibleSkulls) {
                        this.freeSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls));
                    }
                    this.assignSkullEntity(skull);
                }
            }
        }
        return skull;
    }

    public void removeSkull(Vector3i position) {
        Skull skull = this.skulls.remove(position);
        if (skull != null) {
            this.reassignSkullEntity(skull);
        }
    }

    public Skull updateSkull(Vector3i position, BlockState blockState) {
        Skull skull = this.skulls.get(position);
        if (skull != null) {
            this.putSkull(position, skull.uuid, skull.texturesProperty, blockState);
        }
        return skull;
    }

    public void updateVisibleSkulls() {
        if (this.cullingEnabled) {
            if (this.lastPlayerPosition != null && this.session.getPlayerEntity().position().distanceSquared(this.lastPlayerPosition) < 4.0f) {
                return;
            }
            this.lastPlayerPosition = this.session.getPlayerEntity().position();
            this.inRangeSkulls.clear();
            for (Skull skull : this.skulls.values()) {
                if (skull.blockDefinition != null) continue;
                skull.distanceSquared = skull.position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
                if (skull.distanceSquared > this.skullRenderDistanceSquared) {
                    this.freeSkullEntity(skull);
                    continue;
                }
                this.inRangeSkulls.add(skull);
            }
            this.inRangeSkulls.sort(Comparator.comparingInt(Skull::getDistanceSquared));
            for (int i = this.inRangeSkulls.size() - 1; i >= 0; --i) {
                if (i < this.maxVisibleSkulls) {
                    this.assignSkullEntity(this.inRangeSkulls.get(i));
                    continue;
                }
                this.freeSkullEntity(this.inRangeSkulls.get(i));
            }
        }
    }

    private void assignSkullEntity(Skull skull) {
        if (skull.entity != null) {
            return;
        }
        if (!this.cullingEnabled || this.totalSkullEntities < this.maxVisibleSkulls) {
            skull.entity = new SkullPlayerEntity(EntitySpawnContext.DUMMY_CONTEXT.apply(this.session, UUID.randomUUID(), VanillaEntities.PLAYER));
            skull.entity.spawnEntity();
            skull.entity.updateSkull(skull);
            ++this.totalSkullEntities;
        }
    }

    private void freeSkullEntity(Skull skull) {
        if (skull.entity != null) {
            skull.entity.despawnEntity();
            --this.totalSkullEntities;
            skull.entity = null;
        }
    }

    private void reassignSkullEntity(Skull skull) {
        boolean hadEntity = skull.entity != null;
        this.freeSkullEntity(skull);
        if (this.cullingEnabled) {
            this.inRangeSkulls.remove(skull);
            if (hadEntity && this.inRangeSkulls.size() >= this.maxVisibleSkulls) {
                this.assignSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls - 1));
            }
        }
    }

    public void clear() {
        for (Skull skull : this.skulls.values()) {
            if (skull.entity == null) continue;
            skull.entity.despawnEntity();
        }
        this.skulls.clear();
        this.inRangeSkulls.clear();
        this.totalSkullEntities = 0;
        this.lastPlayerPosition = null;
    }

    private @Nullable BlockDefinition translateCustomSkull(String skinHash, BlockState blockState) {
        CustomSkull customSkull = (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
        if (customSkull != null) {
            CustomBlockState customBlockState = blockState.block() instanceof WallSkullBlock ? customSkull.getWallBlockState(WallSkullBlock.getDegrees(blockState)) : customSkull.getFloorBlockState(blockState.getValue(Properties.ROTATION_16));
            return (BlockDefinition)this.session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockState);
        }
        return null;
    }

    @Generated
    public Map<Vector3i, Skull> getSkulls() {
        return this.skulls;
    }

    public static class Skull {
        private UUID uuid;
        private String texturesProperty;
        private String skinHash;
        private BlockState blockState;
        private BlockDefinition blockDefinition;
        private SkullPlayerEntity entity;
        private final Vector3i position;
        private int distanceSquared;

        @Generated
        public Skull(Vector3i position) {
            this.position = position;
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @Generated
        public String getTexturesProperty() {
            return this.texturesProperty;
        }

        @Generated
        public String getSkinHash() {
            return this.skinHash;
        }

        @Generated
        public BlockState getBlockState() {
            return this.blockState;
        }

        @Generated
        public BlockDefinition getBlockDefinition() {
            return this.blockDefinition;
        }

        @Generated
        public SkullPlayerEntity getEntity() {
            return this.entity;
        }

        @Generated
        public Vector3i getPosition() {
            return this.position;
        }

        @Generated
        public int getDistanceSquared() {
            return this.distanceSquared;
        }

        @Generated
        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        @Generated
        public void setTexturesProperty(String texturesProperty) {
            this.texturesProperty = texturesProperty;
        }

        @Generated
        public void setSkinHash(String skinHash) {
            this.skinHash = skinHash;
        }

        @Generated
        public void setBlockState(BlockState blockState) {
            this.blockState = blockState;
        }

        @Generated
        public void setBlockDefinition(BlockDefinition blockDefinition) {
            this.blockDefinition = blockDefinition;
        }

        @Generated
        public void setEntity(SkullPlayerEntity entity) {
            this.entity = entity;
        }

        @Generated
        public void setDistanceSquared(int distanceSquared) {
            this.distanceSquared = distanceSquared;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Skull)) {
                return false;
            }
            Skull other = (Skull)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDistanceSquared() != other.getDistanceSquared()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$texturesProperty = this.getTexturesProperty();
            String other$texturesProperty = other.getTexturesProperty();
            if (this$texturesProperty == null ? other$texturesProperty != null : !this$texturesProperty.equals(other$texturesProperty)) {
                return false;
            }
            String this$skinHash = this.getSkinHash();
            String other$skinHash = other.getSkinHash();
            if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
                return false;
            }
            BlockState this$blockState = this.getBlockState();
            BlockState other$blockState = other.getBlockState();
            if (this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState)) {
                return false;
            }
            BlockDefinition this$blockDefinition = this.getBlockDefinition();
            BlockDefinition other$blockDefinition = other.getBlockDefinition();
            if (this$blockDefinition == null ? other$blockDefinition != null : !this$blockDefinition.equals(other$blockDefinition)) {
                return false;
            }
            SkullPlayerEntity this$entity = this.getEntity();
            SkullPlayerEntity other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Vector3i this$position = this.getPosition();
            Vector3i other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Skull;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDistanceSquared();
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $texturesProperty = this.getTexturesProperty();
            result = result * 59 + ($texturesProperty == null ? 43 : $texturesProperty.hashCode());
            String $skinHash = this.getSkinHash();
            result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
            BlockState $blockState = this.getBlockState();
            result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
            BlockDefinition $blockDefinition = this.getBlockDefinition();
            result = result * 59 + ($blockDefinition == null ? 43 : $blockDefinition.hashCode());
            SkullPlayerEntity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Vector3i $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SkullCache.Skull(uuid=" + String.valueOf(this.getUuid()) + ", texturesProperty=" + this.getTexturesProperty() + ", skinHash=" + this.getSkinHash() + ", blockState=" + String.valueOf(this.getBlockState()) + ", blockDefinition=" + String.valueOf(this.getBlockDefinition()) + ", entity=" + String.valueOf(this.getEntity()) + ", position=" + String.valueOf(this.getPosition()) + ", distanceSquared=" + this.getDistanceSquared() + ")";
        }
    }
}

