/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.codec.v844.Bedrock_v844;
import org.cloudburstmc.protocol.bedrock.codec.v859.Bedrock_v859;
import org.cloudburstmc.protocol.bedrock.codec.v860.Bedrock_v860;
import org.cloudburstmc.protocol.bedrock.codec.v898.Bedrock_v898;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemGroup;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;
import org.cloudburstmc.protocol.common.Definition;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.populator.CreativeItemRegistryPopulator;
import org.geysermc.geyser.registry.populator.CustomItemRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.geyser.registry.type.PaletteItem;
import org.geysermc.geyser.util.JsonUtils;

public class ItemRegistryPopulator {
    public static void populate() {
        ObjectArrayList<NonVanillaCustomItemData> nonVanillaCustomItems;
        Map items;
        HashMap<Item, Item> eightFourFourFallbacks = new HashMap<Item, Item>();
        eightFourFourFallbacks.put(Items.WOODEN_SPEAR, Items.WOODEN_SWORD);
        eightFourFourFallbacks.put(Items.STONE_SPEAR, Items.STONE_SWORD);
        eightFourFourFallbacks.put(Items.COPPER_SPEAR, Items.COPPER_SWORD);
        eightFourFourFallbacks.put(Items.IRON_SPEAR, Items.IRON_SWORD);
        eightFourFourFallbacks.put(Items.GOLDEN_SPEAR, Items.GOLDEN_SWORD);
        eightFourFourFallbacks.put(Items.DIAMOND_SPEAR, Items.DIAMOND_SWORD);
        eightFourFourFallbacks.put(Items.NETHERITE_SPEAR, Items.NETHERITE_SWORD);
        eightFourFourFallbacks.put(Items.COPPER_NAUTILUS_ARMOR, Items.COPPER_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.IRON_NAUTILUS_ARMOR, Items.IRON_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.GOLDEN_NAUTILUS_ARMOR, Items.GOLDEN_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.DIAMOND_NAUTILUS_ARMOR, Items.DIAMOND_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.NETHERITE_NAUTILUS_ARMOR, Items.DIAMOND_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.NETHERITE_HORSE_ARMOR, Items.DIAMOND_HORSE_ARMOR);
        eightFourFourFallbacks.put(Items.NAUTILUS_SPAWN_EGG, Items.PUFFERFISH_SPAWN_EGG);
        eightFourFourFallbacks.put(Items.ZOMBIE_NAUTILUS_SPAWN_EGG, Items.PUFFERFISH_SPAWN_EGG);
        eightFourFourFallbacks.put(Items.CAMEL_HUSK_SPAWN_EGG, Items.CAMEL_SPAWN_EGG);
        eightFourFourFallbacks.put(Items.PARCHED_SPAWN_EGG, Items.SKELETON_SPAWN_EGG);
        ArrayList<PaletteVersion> paletteVersions = new ArrayList<PaletteVersion>(6);
        paletteVersions.add(new PaletteVersion("1_21_110", Bedrock_v844.CODEC.getProtocolVersion(), eightFourFourFallbacks));
        paletteVersions.add(new PaletteVersion("1_21_120", Bedrock_v859.CODEC.getProtocolVersion(), eightFourFourFallbacks));
        paletteVersions.add(new PaletteVersion("1_21_120", Bedrock_v860.CODEC.getProtocolVersion(), eightFourFourFallbacks));
        paletteVersions.add(new PaletteVersion("1_21_130", Bedrock_v898.CODEC.getProtocolVersion()));
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        Type mappingItemsType = new TypeToken<Map<String, GeyserMappingItem>>(){}.getType();
        try (InputStream stream = bootstrap.getResourceOrThrow("mappings/items.json");){
            items = (Map)JsonUtils.fromJson(stream, mappingItemsType);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java runtime item IDs", e);
        }
        boolean customItemsAllowed = GeyserImpl.getInstance().config().gameplay().enableCustomContent();
        ListMultimap customItems = MultimapBuilder.hashKeys().arrayListValues().build();
        ObjectArrayList<NonVanillaCustomItemData> objectArrayList = nonVanillaCustomItems = customItemsAllowed ? new ObjectArrayList<NonVanillaCustomItemData>() : Collections.emptyList();
        if (customItemsAllowed) {
            CustomItemRegistryPopulator.populate(items, (Multimap<String, CustomItemData>)customItems, nonVanillaCustomItems);
        }
        boolean firstMappingsPass = true;
        for (PaletteVersion palette : paletteVersions) {
            ItemDefinition lightBlock;
            NbtMap vanillaComponents;
            List itemEntries;
            Type paletteEntriesType = new TypeToken<List<PaletteItem>>(){}.getType();
            try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/runtime_item_states.%s.json", palette.version()));){
                itemEntries = (List)JsonUtils.fromJson(stream, paletteEntriesType);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            try (InputStream stream = bootstrap.getResourceOrThrow("bedrock/item_components.%s.nbt".formatted(palette.version()));){
                vanillaComponents = (NbtMap)NbtUtils.createGZIPReader(stream, true, true).readTag();
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock item components", e);
            }
            int nextFreeBedrockId = 0;
            Int2ObjectOpenHashMap<ItemDefinition> registry = new Int2ObjectOpenHashMap<ItemDefinition>();
            Object2ObjectLinkedOpenHashMap<String, ItemDefinition> definitions = new Object2ObjectLinkedOpenHashMap<String, ItemDefinition>();
            for (PaletteItem entry2 : itemEntries) {
                NbtMap components;
                int id = entry2.getId();
                if (id >= nextFreeBedrockId) {
                    nextFreeBedrockId = id + 1;
                }
                if ((components = vanillaComponents.getCompound(entry2.getName())) == null && entry2.isComponentBased()) {
                    if (!entry2.getName().contains("lava_chicken")) {
                        throw new RuntimeException("Could not find vanilla components for vanilla component based item! " + entry2.getName());
                    }
                    components = NbtMap.EMPTY;
                }
                SimpleItemDefinition definition = new SimpleItemDefinition(entry2.getName().intern(), id, ItemVersion.from(entry2.getVersion()), entry2.isComponentBased(), components);
                definitions.put(entry2.getName(), definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
            }
            Object2ObjectOpenHashMap bedrockBlockIdOverrides = new Object2ObjectOpenHashMap();
            Object2IntOpenHashMap blacklistedIdentifiers = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions = new Object2ObjectOpenHashMap<CustomBlockData, ItemDefinition>();
            ObjectArrayList<ItemDefinition> buckets = new ObjectArrayList<ItemDefinition>();
            ObjectArrayList mappings = new ObjectArrayList();
            Object2ObjectOpenHashMap<Item, ItemMapping> javaItemToMapping = new Object2ObjectOpenHashMap<Item, ItemMapping>();
            ArrayList<CreativeItemData> creativeItems = new ArrayList<CreativeItemData>();
            ObjectOpenHashSet noBlockDefinitions = new ObjectOpenHashSet();
            noBlockDefinitions.add("minecraft:structure_block");
            noBlockDefinitions.add("minecraft:structure_void");
            AtomicInteger creativeNetId = new AtomicInteger();
            CreativeItemRegistryPopulator.populate(palette, definitions, items, (itemBuilder, groupId) -> {
                ItemData item = itemBuilder.netId(creativeNetId.incrementAndGet()).build();
                creativeItems.add(new CreativeItemData(item, item.getNetId(), (int)groupId));
                if (item.getBlockDefinition() != null) {
                    String identifier = item.getDefinition().getIdentifier();
                    if (!blacklistedIdentifiers.containsKey(identifier)) {
                        if (bedrockBlockIdOverrides.containsKey(identifier)) {
                            bedrockBlockIdOverrides.remove(identifier);
                            blacklistedIdentifiers.put(identifier, item.getBlockDefinition().getRuntimeId());
                        } else {
                            bedrockBlockIdOverrides.put(identifier, item.getBlockDefinition());
                        }
                    }
                } else {
                    noBlockDefinitions.add(item.getDefinition().getIdentifier());
                }
            });
            List<CreativeItemGroup> creativeItemGroups = CreativeItemRegistryPopulator.readCreativeItemGroups(palette, creativeItems);
            BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
            ObjectOpenHashSet<Item> javaOnlyItems = new ObjectOpenHashSet<Item>();
            Collections.addAll(javaOnlyItems, Items.SPECTRAL_ARROW, Items.DEBUG_STICK, Items.KNOWLEDGE_BOOK, Items.TIPPED_ARROW);
            if (!customItemsAllowed) {
                javaOnlyItems.add(Items.FURNACE_MINECART);
            }
            javaOnlyItems.addAll(palette.javaOnlyItems().keySet());
            Int2ObjectOpenHashMap<String> customIdMappings = new Int2ObjectOpenHashMap<String>();
            ObjectOpenHashSet registeredItemNames = new ObjectOpenHashSet();
            for (Map.Entry entry3 : items.entrySet()) {
                List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions;
                Object bedrockBlock;
                Object definition;
                String bedrockIdentifier;
                GeyserMappingItem mappingItem;
                Item javaItem;
                block69: {
                    Object blockTag;
                    int aValidBedrockBlockId;
                    CustomBlockData customBlockData;
                    Definition customBlockItemOverride;
                    Integer firstBlockRuntimeId;
                    block71: {
                        block70: {
                            javaItem = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get((String)entry3.getKey());
                            if (javaItem == null) {
                                throw new RuntimeException("Extra item in mappings? " + (String)entry3.getKey());
                            }
                            Item replacementItem = palette.javaOnlyItems().get(javaItem);
                            mappingItem = replacementItem != null ? (GeyserMappingItem)items.get(replacementItem.javaIdentifier()) : palette.remapper().remap(javaItem, (GeyserMappingItem)entry3.getValue());
                            if (customItemsAllowed && javaItem == Items.FURNACE_MINECART) {
                                mappings.add(null);
                                continue;
                            }
                            bedrockIdentifier = mappingItem.getBedrockIdentifier();
                            definition = (ItemDefinition)definitions.get(bedrockIdentifier);
                            if (definition == null) {
                                throw new RuntimeException("Missing Bedrock ItemDefinition in version " + palette.version() + " for mapping: " + String.valueOf(mappingItem));
                            }
                            bedrockBlock = null;
                            firstBlockRuntimeId = ((GeyserMappingItem)entry3.getValue()).getFirstBlockRuntimeId();
                            customBlockItemOverride = null;
                            if (firstBlockRuntimeId == null) break block69;
                            BlockDefinition blockOverride = (BlockDefinition)bedrockBlockIdOverrides.get(bedrockIdentifier);
                            customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(javaItem.javaIdentifier(), null);
                            if (customBlockData != null && customBlockData.includedInCreativeInventory()) {
                                CustomBlockState customBlockState = customBlockData.defaultBlockState();
                                customBlockItemOverride = blockMappings.getCustomBlockStateDefinitions().getOrDefault(customBlockState, null);
                            }
                            if (blockOverride == null || customBlockItemOverride != null) break block70;
                            bedrockBlock = blockOverride;
                            break block69;
                        }
                        aValidBedrockBlockId = blacklistedIdentifiers.getOrDefault((Object)bedrockIdentifier, customBlockItemOverride != null ? customBlockItemOverride.getRuntimeId() : -1);
                        if (aValidBedrockBlockId != -1 || customBlockItemOverride != null) break block71;
                        if (noBlockDefinitions.contains(((GeyserMappingItem)entry3.getValue()).getBedrockIdentifier())) break block69;
                        bedrockBlock = blockMappings.getBedrockBlock(firstBlockRuntimeId);
                        break block69;
                    }
                    NbtMapBuilder requiredBlockStatesBuilder = NbtMap.builder();
                    String correctBedrockIdentifier = blockMappings.getDefinition(aValidBedrockBlockId).getState().getString("name");
                    boolean firstPass = true;
                    int lastBlockRuntimeId = ((GeyserMappingItem)entry3.getValue()).getLastBlockRuntimeId() == null ? firstBlockRuntimeId : ((GeyserMappingItem)entry3.getValue()).getLastBlockRuntimeId();
                    for (int i = firstBlockRuntimeId.intValue(); i <= lastBlockRuntimeId; ++i) {
                        GeyserBedrockBlock[] bedrockBlockRuntimeId = blockMappings.getVanillaBedrockBlock(i);
                        NbtMap blockTag2 = bedrockBlockRuntimeId.getState();
                        String bedrockName = blockTag2.getString("name");
                        if (!bedrockName.equals(correctBedrockIdentifier)) continue;
                        NbtMap states = blockTag2.getCompound("states");
                        if (firstPass) {
                            firstPass = false;
                            if (states.isEmpty()) {
                                bedrockBlock = bedrockBlockRuntimeId;
                                break;
                            }
                            requiredBlockStatesBuilder.putAll(states);
                            continue;
                        }
                        for (Map.Entry<String, Object> entry2 : states.entrySet()) {
                            Object value = requiredBlockStatesBuilder.get(entry2.getKey());
                            if (value == null || entry2.getValue().equals(value)) continue;
                            requiredBlockStatesBuilder.remove(entry2.getKey());
                        }
                        if (requiredBlockStatesBuilder.isEmpty()) break;
                    }
                    NbtMap requiredBlockStates = requiredBlockStatesBuilder.build();
                    if (bedrockBlock == null) {
                        for (GeyserBedrockBlock block : blockMappings.getBedrockRuntimeMap()) {
                            if (block == null || !((NbtMap)(blockTag = block.getState())).getString("name").equals(correctBedrockIdentifier)) continue;
                            NbtMap nbtMap = ((NbtMap)blockTag).getCompound("states");
                            boolean valid = true;
                            for (Map.Entry<String, Object> nbtEntry : requiredBlockStates.entrySet()) {
                                if (nbtMap.get(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            bedrockBlock = block;
                            break;
                        }
                        if (bedrockBlock == null) {
                            throw new RuntimeException("Could not find a block match for " + (String)entry3.getKey());
                        }
                    }
                    if (customBlockItemOverride != null) {
                        bedrockBlock = customBlockItemOverride;
                    }
                    for (int j = 0; j < creativeItems.size(); ++j) {
                        CreativeItemData itemData = (CreativeItemData)creativeItems.get(j);
                        if (!itemData.getItem().getDefinition().equals(definition)) continue;
                        if (itemData.getItem().getDamage() != 0) break;
                        NbtMap states = ((GeyserBedrockBlock)itemData.getItem().getBlockDefinition()).getState().getCompound("states");
                        boolean valid = true;
                        blockTag = requiredBlockStates.entrySet().iterator();
                        while (blockTag.hasNext()) {
                            Map.Entry entry4 = (Map.Entry)blockTag.next();
                            if (Objects.equals(states.get(entry4.getKey()), entry4.getValue())) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        if (customBlockItemOverride != null && customBlockData != null) {
                            int customProtocolId = nextFreeBedrockId++;
                            mappingItem = mappingItem.withBedrockData(customProtocolId);
                            bedrockIdentifier = customBlockData.identifier();
                            definition = new SimpleItemDefinition(bedrockIdentifier, customProtocolId, ItemVersion.DATA_DRIVEN, true, NbtMap.EMPTY);
                            registry.put(customProtocolId, (ItemDefinition)definition);
                            customBlockItemDefinitions.put(customBlockData, (ItemDefinition)definition);
                            customIdMappings.put(customProtocolId, bedrockIdentifier);
                            CreativeItemData creativeItemData = new CreativeItemData(itemData.getItem().toBuilder().definition((ItemDefinition)definition).blockDefinition((BlockDefinition)bedrockBlock).netId(itemData.getNetId()).count(1).build(), itemData.getNetId(), 0);
                            creativeItems.set(j, creativeItemData);
                            break;
                        }
                        CreativeItemData creativeItemData = new CreativeItemData(itemData.getItem().toBuilder().blockDefinition((BlockDefinition)bedrockBlock).build(), itemData.getNetId(), 0);
                        creativeItems.set(j, creativeItemData);
                        break;
                    }
                }
                ItemMapping.ItemMappingBuilder mappingBuilder = ItemMapping.builder().bedrockIdentifier(bedrockIdentifier.intern()).bedrockDefinition((ItemDefinition)definition).bedrockData(mappingItem.getBedrockData()).bedrockBlockDefinition((BlockDefinition)bedrockBlock).javaItem(javaItem);
                if (mappingItem.getToolType() != null) {
                    mappingBuilder = mappingBuilder.toolType(mappingItem.getToolType().intern());
                }
                if (javaOnlyItems.contains(javaItem)) {
                    mappingBuilder = mappingBuilder.translationString((javaItem instanceof BlockItem ? "block." : "item.") + ((String)entry3.getKey()).replace(":", "."));
                    GeyserImpl.getInstance().getLogger().debug("Adding " + (String)entry3.getKey() + " as an item that needs to be translated.");
                }
                Collection customItemsToLoad = customItems.get((Object)javaItem.javaIdentifier());
                if (customItemsAllowed && !customItemsToLoad.isEmpty()) {
                    customItemOptions = new ObjectArrayList<Pair<CustomItemOptions, ItemDefinition>>(customItemsToLoad.size());
                    for (CustomItemData customItem : customItemsToLoad) {
                        String customItemName;
                        int customProtocolId = nextFreeBedrockId++;
                        if (customItem instanceof NonVanillaCustomItemData) {
                            NonVanillaCustomItemData nonVanillaItem = (NonVanillaCustomItemData)customItem;
                            v1 = nonVanillaItem.identifier();
                        } else {
                            v1 = customItemName = "geyser_custom:" + customItem.name();
                        }
                        if (!registeredItemNames.add(customItemName)) {
                            if (!firstMappingsPass) continue;
                            GeyserImpl.getInstance().getLogger().error("Custom item name '" + customItemName + "' already exists and was registered again! Skipping...");
                            continue;
                        }
                        GeyserCustomMappingData customMapping = CustomItemRegistryPopulator.registerCustomItem(customItemName, javaItem, mappingItem, customItem, customProtocolId, palette.protocolVersion);
                        if (customItem.creativeCategory().isPresent()) {
                            CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().netId(creativeNetId.incrementAndGet()).definition(customMapping.itemDefinition()).blockDefinition(null).count(1).build(), creativeNetId.get(), customItem.creativeCategory().getAsInt());
                            creativeItems.add(creativeItemData);
                        }
                        customItemOptions.add(Pair.of(customItem.customItemOptions(), customMapping.itemDefinition()));
                        registry.put(customMapping.integerId(), customMapping.itemDefinition());
                        customIdMappings.put(customMapping.integerId(), customMapping.stringId());
                    }
                    Collections.reverse(customItemOptions);
                } else {
                    customItemOptions = Collections.emptyList();
                }
                mappingBuilder.customItemOptions(customItemOptions);
                ItemMapping mapping = mappingBuilder.build();
                if (javaItem.javaIdentifier().contains("bucket") && !javaItem.javaIdentifier().contains("milk")) {
                    buckets.add(definition);
                }
                mappings.add(mapping);
                javaItemToMapping.put(javaItem, mapping);
            }
            Int2ObjectOpenHashMap<ItemMapping> lightBlocks = new Int2ObjectOpenHashMap<ItemMapping>();
            for (int i = 0; i <= Properties.LEVEL.high() && (lightBlock = (ItemDefinition)definitions.get("minecraft:light_block_" + i)) != null; ++i) {
                ItemMapping lightBlockEntry = ItemMapping.builder().javaItem(Items.LIGHT).bedrockIdentifier("minecraft:light_block_" + i).bedrockDefinition(lightBlock).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build();
                lightBlocks.put(lightBlock.getRuntimeId(), lightBlockEntry);
            }
            ItemDefinition lodestoneCompass = (ItemDefinition)definitions.get("minecraft:lodestone_compass");
            if (lodestoneCompass == null) {
                throw new RuntimeException("Lodestone compass not found in item palette!");
            }
            ItemMapping lodestoneEntry = ItemMapping.builder().javaItem(Items.COMPASS).bedrockIdentifier("minecraft:lodestone_compass").bedrockDefinition(lodestoneCompass).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build();
            if (customItemsAllowed) {
                int furnaceMinecartId = nextFreeBedrockId++;
                SimpleItemDefinition definition = new SimpleItemDefinition("geysermc:furnace_minecart", furnaceMinecartId, ItemVersion.DATA_DRIVEN, true, ItemRegistryPopulator.registerFurnaceMinecart(furnaceMinecartId));
                definitions.put("geysermc:furnace_minecart", definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
                mappings.set(Items.FURNACE_MINECART.javaId(), ItemMapping.builder().javaItem(Items.FURNACE_MINECART).bedrockIdentifier("geysermc:furnace_minecart").bedrockDefinition(definition).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build());
                creativeItems.add(new CreativeItemData(ItemData.builder().usingNetId(true).netId(creativeNetId.incrementAndGet()).definition(definition).count(1).build(), creativeNetId.get(), 99));
                IntOpenHashSet registeredJavaIds = new IntOpenHashSet();
                for (NonVanillaCustomItemData customItem : nonVanillaCustomItems) {
                    if (!registeredJavaIds.add(customItem.javaId())) {
                        if (!firstMappingsPass) continue;
                        GeyserImpl.getInstance().getLogger().error("Custom item java id " + customItem.javaId() + " already exists and was registered again! Skipping...");
                        continue;
                    }
                    int customItemId = nextFreeBedrockId++;
                    NonVanillaItemRegistration registration = CustomItemRegistryPopulator.registerCustomItem(customItem, customItemId, palette.protocolVersion);
                    ItemMapping mapping = registration.mapping();
                    Item javaItem = registration.javaItem();
                    while (javaItem.javaId() >= mappings.size()) {
                        mappings.add(ItemMapping.AIR);
                    }
                    mappings.set(javaItem.javaId(), mapping);
                    registry.put(customItemId, mapping.getBedrockDefinition());
                    if (!customItem.creativeCategory().isPresent()) continue;
                    CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().definition(registration.mapping().getBedrockDefinition()).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), customItem.creativeCategory().getAsInt());
                    creativeItems.add(creativeItemData);
                }
            }
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    if (customBlockItemDefinitions.containsKey(customBlock) || customBlock instanceof NonVanillaCustomBlockData) continue;
                    int customProtocolId = nextFreeBedrockId++;
                    String identifier = customBlock.identifier();
                    SimpleItemDefinition definition = new SimpleItemDefinition(identifier, customProtocolId, ItemVersion.NONE, false, null);
                    registry.put(customProtocolId, (ItemDefinition)definition);
                    customBlockItemDefinitions.put(customBlock, definition);
                    customIdMappings.put(customProtocolId, identifier);
                    GeyserBedrockBlock bedrockBlock = blockMappings.getCustomBlockStateDefinitions().getOrDefault(customBlock.defaultBlockState(), null);
                    if (bedrockBlock == null || !customBlock.includedInCreativeInventory()) continue;
                    CreativeItemData creativeItemData = new CreativeItemData(ItemData.builder().definition(definition).blockDefinition(bedrockBlock).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), customBlock.creativeCategory().id());
                    creativeItems.add(creativeItemData);
                }
            }
            ItemMappings itemMappings = ItemMappings.builder().items(mappings.toArray(new ItemMapping[0])).zeroBlockDefinitionRuntimeId((Integer[])mappings.stream().filter(entry -> entry.isBlock() && entry.getBedrockBlockDefinition().getRuntimeId() == 0).map(itemMapping -> itemMapping.getBedrockDefinition().getRuntimeId()).toArray(Integer[]::new)).creativeItems(creativeItems).creativeItemGroups(creativeItemGroups).itemDefinitions(registry).storedItems(new StoredItemMappings(javaItemToMapping)).javaOnlyItems(javaOnlyItems).buckets(buckets).lightBlocks(lightBlocks).lodestoneCompass(lodestoneEntry).customIdMappings(customIdMappings).customBlockItemDefinitions(customBlockItemDefinitions).build();
            Registries.ITEMS.register(palette.protocolVersion(), itemMappings);
            firstMappingsPass = false;
        }
    }

    private static NbtMap registerFurnaceMinecart(int nextFreeBedrockId) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", "geysermc:furnace_minecart").putInt("id", nextFreeBedrockId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        NbtMap iconMap = NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", "minecart_furnace").build()).build();
        itemProperties.putCompound("minecraft:icon", iconMap);
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", "item.minecartFurnace.name").build());
        List<NbtMap> useOnTag = Collections.singletonList(NbtMap.builder().putString("tags", "q.any_tag('rail')").build());
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.COMPOUND, useOnTag).putString("entity", "minecraft:minecart").putList("use_on", NbtType.COMPOUND, useOnTag).build());
        itemProperties.putBoolean("allow_off_hand", true);
        itemProperties.putBoolean("hand_equipped", false);
        itemProperties.putInt("max_stack_size", 1);
        itemProperties.putString("creative_group", "itemGroup.name.minecart");
        itemProperties.putInt("creative_category", 4);
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder.build();
    }

    record PaletteVersion(String version, int protocolVersion, Map<Item, Item> javaOnlyItems, Remapper remapper) {
        public PaletteVersion(String version, int protocolVersion) {
            this(version, protocolVersion, Collections.emptyMap(), (item, mapping) -> mapping);
        }

        public PaletteVersion(String version, int protocolVersion, Map<Item, Item> javaOnlyItems) {
            this(version, protocolVersion, javaOnlyItems, (item, mapping) -> mapping);
        }

        public PaletteVersion(String version, int protocolVersion, Remapper remapper) {
            this(version, protocolVersion, Collections.emptyMap(), remapper);
        }
    }

    @FunctionalInterface
    static interface Remapper {
        public @NonNull GeyserMappingItem remap(Item var1, GeyserMappingItem var2);
    }
}

