/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.translator.level.event.LevelEventTranslator;
import org.geysermc.geyser.translator.level.event.PlaySoundEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundEventEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundLevelEventTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEventType;

public class SoundEventsRegistryLoader
extends EffectRegistryLoader<Map<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator>> {
    @Override
    public Map<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator> load(String input) {
        this.loadFile(input);
        JsonObject effectsJson = this.loadFile(input);
        Object2ObjectOpenHashMap<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator> soundEffects = new Object2ObjectOpenHashMap<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator>();
        for (Map.Entry entry : effectsJson.entrySet()) {
            JsonObject node = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                String type = node.get("type").getAsString();
                LevelEventType javaEffect = null;
                Record transformer = null;
                switch (type) {
                    case "soundLevel": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        LevelEvent levelEventType = LevelEvent.valueOf(node.get("name").getAsString());
                        int data = node.has("data") ? node.get("data").getAsInt() : 0;
                        transformer = new SoundLevelEventTranslator(levelEventType, data);
                        break;
                    }
                    case "soundEvent": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        SoundEvent soundEvent = SoundEvent.valueOf(node.get("name").getAsString());
                        String identifier = node.has("identifier") ? node.get("identifier").getAsString() : "";
                        int extraData = node.has("extraData") ? node.get("extraData").getAsInt() : -1;
                        transformer = new SoundEventEventTranslator(soundEvent, identifier, extraData);
                        break;
                    }
                    case "playSound": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        String name = node.get("name").getAsString();
                        float volume = node.has("volume") ? node.get("volume").getAsFloat() : 1.0f;
                        boolean pitchSub = node.has("pitch_sub") && node.get("pitch_sub").getAsBoolean();
                        float pitchMul = node.has("pitch_mul") ? node.get("pitch_mul").getAsFloat() : 1.0f;
                        float pitchAdd = node.has("pitch_add") ? node.get("pitch_add").getAsFloat() : 0.0f;
                        boolean relative = !node.has("relative") || node.get("relative").getAsBoolean();
                        transformer = new PlaySoundEventTranslator(name, volume, pitchSub, pitchMul, pitchAdd, relative);
                    }
                }
                if (javaEffect == null) continue;
                soundEffects.put(javaEffect, (LevelEventTranslator)((Object)transformer));
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().warning("Failed to map sound effect " + (String)entry.getKey() + " : " + String.valueOf(e));
            }
        }
        return soundEffects;
    }
}

