/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.transformation;

import java.util.Map;
import java.util.NavigableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.ConfigurateException;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.NodePath;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.transformation.ConfigurationTransformation;

class VersionedTransformation
implements ConfigurationTransformation.Versioned {
    private final NodePath versionPath;
    private final NavigableMap<Integer, ConfigurationTransformation> versionTransformations;

    VersionedTransformation(NodePath versionPath, NavigableMap<Integer, ConfigurationTransformation> versionTransformations) {
        this.versionPath = versionPath;
        this.versionTransformations = versionTransformations;
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        ConfigurationNode versionNode = node.node(this.versionPath);
        int currentVersion = versionNode.getInt(-1);
        for (Map.Entry entry : this.versionTransformations.entrySet()) {
            if ((Integer)entry.getKey() <= currentVersion) continue;
            try {
                ((ConfigurationTransformation)entry.getValue()).apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                }
                thrown.addSuppressed(ex);
            }
            currentVersion = (Integer)entry.getKey();
        }
        if (thrown != null) {
            throw thrown;
        }
        versionNode.set(currentVersion);
    }

    @Override
    public NodePath versionKey() {
        return this.versionPath;
    }

    @Override
    public int latestVersion() {
        return (Integer)this.versionTransformations.lastKey();
    }
}

