/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import org.geysermc.geyser.util.metrics.MetricsPlatform;

public final class BungeeMetrics
implements MetricsPlatform {
    private final Configuration configuration;

    public BungeeMetrics(Plugin plugin) throws IOException {
        File bStatsFolder = new File(plugin.getDataFolder().getParentFile(), "bStats");
        bStatsFolder.mkdirs();
        File configFile = new File(bStatsFolder, "config.yml");
        if (!configFile.exists()) {
            this.writeFile(configFile, "# bStats (https://bStats.org) collects some basic information for plugin authors, like how", "# many people use their plugin and their total player count. It's recommended to keep bStats", "# enabled, but if you're not comfortable with this, you can turn this setting off. There is no", "# performance penalty associated with having metrics enabled, and data sent to bStats is fully", "# anonymous.", "enabled: true", "serverUuid: \"" + String.valueOf(UUID.randomUUID()) + "\"", "logFailedRequests: false", "logSentData: false", "logResponseStatusText: false");
        }
        this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
    }

    @Override
    public boolean enabled() {
        return this.configuration.getBoolean("enabled", true);
    }

    @Override
    public String serverUuid() {
        return this.configuration.getString("serverUuid");
    }

    @Override
    public boolean logFailedRequests() {
        return this.configuration.getBoolean("logFailedRequests", false);
    }

    @Override
    public boolean logSentData() {
        return this.configuration.getBoolean("logSentData", false);
    }

    @Override
    public boolean logResponseStatusText() {
        return this.configuration.getBoolean("logResponseStatusText", false);
    }

    private void writeFile(File file, String ... lines) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
        }
    }
}

