/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.network.netty.LocalChannelWithRemoteAddress;
import org.geysermc.mcprotocollib.network.helper.NettyHelper;
import org.geysermc.mcprotocollib.network.netty.MinecraftChannelInitializer;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.network.session.ClientNetworkSession;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;

public final class LocalSession
extends ClientNetworkSession {
    private static EventLoopGroup DEFAULT_EVENT_LOOP_GROUP;
    private static PreferredDirectByteBufAllocator PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR;
    private final SocketAddress spoofedRemoteAddress;

    public LocalSession(SocketAddress targetAddress, String clientIp, MinecraftProtocol protocol, Executor packetHandlerExecutor) {
        super(targetAddress, protocol, packetHandlerExecutor, null, null);
        this.spoofedRemoteAddress = new InetSocketAddress(clientIp, 0);
    }

    @Override
    protected ChannelFactory<? extends Channel> getChannelFactory() {
        return new ReflectiveChannelFactory(LocalChannelWithRemoteAddress.class);
    }

    @Override
    protected void setOptions(Bootstrap bootstrap) {
        if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR != null) {
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR);
        }
    }

    @Override
    protected EventLoopGroup getEventLoopGroup() {
        if (DEFAULT_EVENT_LOOP_GROUP == null) {
            DEFAULT_EVENT_LOOP_GROUP = new DefaultEventLoopGroup((ThreadFactory)new DefaultThreadFactory(this.getClass(), true));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> DEFAULT_EVENT_LOOP_GROUP.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS)));
        }
        return DEFAULT_EVENT_LOOP_GROUP;
    }

    @Override
    protected ChannelHandler getChannelHandler() {
        return new MinecraftChannelInitializer<LocalSession>(channel -> {
            MinecraftProtocol protocol = this.getPacketProtocol();
            ((PacketProtocol)protocol).newClientSession(this);
            return this;
        }, true){

            @Override
            public void initChannel(@NonNull Channel channel) throws Exception {
                ((LocalChannelWithRemoteAddress)channel).spoofedRemoteAddress(LocalSession.this.spoofedRemoteAddress);
                NettyHelper.initializeHAProxySupport(LocalSession.this, channel);
                super.initChannel(channel);
            }
        };
    }

    public static void createDirectByteBufAllocator() {
        if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR == null) {
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = new PreferredDirectByteBufAllocator();
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR.updateAllocator(ByteBufAllocator.DEFAULT);
        }
    }

    static {
        PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = null;
    }
}

