/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.click;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.item.hashing.DataComponentHashers;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BundleInventoryTranslator;
import org.geysermc.geyser.translator.inventory.CraftingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.thirdparty.Fraction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerActionType;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.MoveToHotbarAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.HashedStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClickPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSelectBundleItemPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetCreativeModeSlotPacket;
import org.jetbrains.annotations.Contract;

public final class ClickPlan {
    private final List<ClickAction> plan = new ArrayList<ClickAction>();
    private final Int2ObjectMap<GeyserItemStack> simulatedItems;
    private Int2ObjectMap<ItemStack> changedItems;
    private Int2ObjectMap<HashedStack> changedHashedItems;
    private GeyserItemStack simulatedCursor;
    private int desiredBundleSlot;
    private boolean executionBegan;
    private final GeyserSession session;
    private final InventoryTranslator<?> translator;
    private final Inventory inventory;
    private final int gridSize;

    public ClickPlan(GeyserSession session, InventoryTranslator<?> translator, Inventory inventory) {
        this.session = session;
        this.translator = translator;
        this.inventory = inventory;
        this.simulatedItems = new Int2ObjectOpenHashMap<GeyserItemStack>(inventory.getSize());
        this.changedItems = null;
        this.changedHashedItems = null;
        this.simulatedCursor = session.getPlayerInventory().getCursor().copy();
        this.executionBegan = false;
        this.gridSize = translator.getGridSize();
    }

    private void resetSimulation() {
        this.simulatedItems.clear();
        this.simulatedCursor = this.session.getPlayerInventory().getCursor().copy();
    }

    public void add(Click click, int slot) {
        this.add(click, slot, false);
    }

    public void add(Click click, int slot, boolean force) {
        if (this.executionBegan) {
            throw new UnsupportedOperationException("ClickPlan already executed");
        }
        if (click == Click.LEFT_OUTSIDE || click == Click.RIGHT_OUTSIDE) {
            slot = -999;
        }
        ClickAction action = new ClickAction(click, slot, force);
        this.plan.add(action);
        this.simulateAction(action);
    }

    public void execute(boolean refresh) {
        this.executionBegan = true;
        this.resetSimulation();
        ListIterator<ClickAction> planIter = this.plan.listIterator();
        while (planIter.hasNext()) {
            int stateId;
            ClickAction action = planIter.next();
            if (action.slot != -999 && this.translator.getSlotType(action.slot) != SlotType.NORMAL) {
                refresh = true;
            }
            this.changedItems = new Int2ObjectOpenHashMap<ItemStack>();
            this.changedHashedItems = new Int2ObjectOpenHashMap<HashedStack>();
            boolean bl = this.session.isEmulatePost1_16Logic();
            if (bl) {
                stateId = this.stateIdHack(action);
                this.simulateAction(action);
            } else {
                stateId = this.inventory.getStateId();
            }
            Object clickedItemStack = bl ? this.simulatedCursor.getItemStack() : (!planIter.hasNext() && refresh ? InventoryUtils.REFRESH_ITEM : (action.click.actionType == ContainerActionType.DROP_ITEM || action.slot == -999 ? null : this.getItem(action.slot).getItemStack()));
            if (!bl) {
                this.simulateAction(action);
            }
            ServerboundContainerClickPacket clickPacket = new ServerboundContainerClickPacket(this.inventory.getJavaId(), stateId, action.slot, action.click.actionType, action.click.action, DataComponentHashers.hashStack(this.session, (ItemStack)clickedItemStack), this.changedHashedItems);
            this.session.sendDownstreamGamePacket(clickPacket);
        }
        this.session.getPlayerInventory().setCursor(this.simulatedCursor, this.session);
        for (Int2ObjectMap.Entry entry : this.simulatedItems.int2ObjectEntrySet()) {
            this.inventory.setItem(entry.getIntKey(), (GeyserItemStack)entry.getValue(), this.session);
        }
    }

    public void executeForCreativeMode() {
        this.executionBegan = true;
        this.resetSimulation();
        this.changedItems = new Int2ObjectOpenHashMap<ItemStack>();
        this.changedHashedItems = new Int2ObjectOpenHashMap<HashedStack>();
        for (ClickAction clickAction : this.plan) {
            this.simulateAction(clickAction);
        }
        this.session.getPlayerInventory().setCursor(this.simulatedCursor, this.session);
        for (Int2ObjectMap.Entry entry : this.simulatedItems.int2ObjectEntrySet()) {
            this.inventory.setItem(entry.getIntKey(), (GeyserItemStack)entry.getValue(), this.session);
        }
        for (Int2ObjectMap.Entry entry : this.changedItems.int2ObjectEntrySet()) {
            ItemStack value = (ItemStack)entry.getValue();
            ItemStack toSend = InventoryUtils.isEmpty(value) ? new ItemStack(-1, 0, null) : value;
            this.session.sendDownstreamGamePacket(new ServerboundSetCreativeModeSlotPacket((short)entry.getIntKey(), toSend));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean canStack(int slot, GeyserItemStack item) {
        GeyserItemStack slotItem = this.simulatedItems.getOrDefault(slot, this.inventory.getItem(slot));
        return InventoryUtils.canStack(slotItem, item);
    }

    public boolean isEmpty(int slot) {
        return this.simulatedItems.getOrDefault(slot, this.inventory.getItem(slot)).isEmpty();
    }

    public GeyserItemStack getItem(int slot) {
        return this.simulatedItems.computeIfAbsent(slot, k -> this.inventory.getItem(slot).copy());
    }

    public void setDesiredBundleSlot(int desiredBundleSlot) {
        this.desiredBundleSlot = desiredBundleSlot;
    }

    public GeyserItemStack getCursor() {
        return this.simulatedCursor;
    }

    private void setItem(int slot, GeyserItemStack item) {
        this.simulatedItems.put(slot, item);
        this.onSlotItemChange(slot, item);
    }

    private void setCursor(GeyserItemStack item) {
        this.simulatedCursor = item;
    }

    private void add(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.add(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void sub(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.sub(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void setAmount(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.setAmount(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void onSlotItemChange(int slot, GeyserItemStack itemStack) {
        if (this.changedItems != null) {
            this.changedItems.put(slot, itemStack.getItemStack());
            this.changedHashedItems.put(slot, DataComponentHashers.hashStack(this.session, itemStack.getItemStack()));
        }
    }

    private void simulateAction(ClickAction action) {
        GeyserItemStack cursor = this.getCursor();
        switch (action.click) {
            case LEFT_OUTSIDE: {
                this.setCursor(GeyserItemStack.EMPTY);
                return;
            }
            case RIGHT_OUTSIDE: {
                if (!cursor.isEmpty()) {
                    cursor.sub(1);
                }
                return;
            }
        }
        GeyserItemStack clicked = this.getItem(action.slot);
        if (this.translator.getSlotType(action.slot) == SlotType.OUTPUT) {
            switch (action.click) {
                case LEFT: 
                case RIGHT: {
                    if (cursor.isEmpty() && !clicked.isEmpty()) {
                        this.setCursor(clicked.copy());
                    } else if (InventoryUtils.canStack(cursor, clicked)) {
                        cursor.add(clicked.getAmount());
                    }
                    this.reduceCraftingGrid(false);
                    this.setItem(action.slot, GeyserItemStack.EMPTY);
                    break;
                }
                case LEFT_SHIFT: {
                    this.reduceCraftingGrid(true);
                }
            }
        } else {
            switch (action.click) {
                case LEFT: {
                    if (!InventoryUtils.canStack(cursor, clicked)) {
                        this.setCursor(clicked);
                        this.setItem(action.slot, cursor);
                        break;
                    }
                    this.setCursor(GeyserItemStack.EMPTY);
                    this.add(action.slot, clicked, cursor.getAmount());
                    break;
                }
                case RIGHT: {
                    if (cursor.isEmpty() && !clicked.isEmpty()) {
                        int half = clicked.getAmount() / 2;
                        this.setCursor(clicked.copy(clicked.getAmount() - half));
                        this.setAmount(action.slot, clicked, half);
                        break;
                    }
                    if (!cursor.isEmpty() && clicked.isEmpty()) {
                        cursor.sub(1);
                        this.setItem(action.slot, cursor.copy(1));
                        break;
                    }
                    if (InventoryUtils.canStack(cursor, clicked)) {
                        cursor.sub(1);
                        this.add(action.slot, clicked, 1);
                        break;
                    }
                    this.setCursor(clicked);
                    this.setItem(action.slot, cursor);
                    break;
                }
                case LEFT_BUNDLE: {
                    Fraction bundleWeight = BundleInventoryTranslator.calculateBundleWeight(clicked.getBundleData().contents());
                    int amountToAddInBundle = Math.min(BundleInventoryTranslator.capacityForItemStack(bundleWeight, cursor), cursor.getAmount());
                    GeyserItemStack toInsertInBundle = cursor.copy(amountToAddInBundle);
                    if (this.executionBegan) {
                        clicked.getBundleData().contents().add(0, toInsertInBundle);
                        this.session.getBundleCache().onItemAdded(clicked);
                    }
                    this.onSlotItemChange(action.slot, clicked);
                    cursor.sub(amountToAddInBundle);
                    break;
                }
                case LEFT_BUNDLE_FROM_CURSOR: {
                    List<GeyserItemStack> contents = cursor.getBundleData().contents();
                    Fraction bundleWeight = BundleInventoryTranslator.calculateBundleWeight(contents);
                    int amountToAddInBundle = Math.min(BundleInventoryTranslator.capacityForItemStack(bundleWeight, clicked), clicked.getAmount());
                    GeyserItemStack toInsertInBundle = clicked.copy(amountToAddInBundle);
                    if (this.executionBegan) {
                        cursor.getBundleData().contents().add(0, toInsertInBundle);
                        this.session.getBundleCache().onItemAdded(cursor);
                    }
                    this.sub(action.slot, clicked, amountToAddInBundle);
                    break;
                }
                case RIGHT_BUNDLE: {
                    if (!cursor.isEmpty()) {
                        GeyserItemStack itemStack = cursor.getBundleData().contents().remove(0);
                        if (this.executionBegan) {
                            this.session.getBundleCache().onItemRemoved(cursor, 0);
                        }
                        this.setItem(action.slot, itemStack);
                        break;
                    }
                    if (this.executionBegan) {
                        this.sendSelectedBundleSlot(action.slot);
                    }
                    GeyserItemStack itemStack = clicked.getBundleData().contents().remove(this.desiredBundleSlot);
                    if (this.executionBegan) {
                        this.session.getBundleCache().onItemRemoved(clicked, this.desiredBundleSlot);
                    }
                    this.onSlotItemChange(action.slot, clicked);
                    this.setCursor(itemStack);
                    break;
                }
                case SWAP_TO_HOTBAR_1: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(0), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_2: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(1), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_3: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(2), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_4: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(3), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_5: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(4), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_6: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(5), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_7: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(6), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_8: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(7), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_9: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(8), clicked);
                    break;
                }
                case LEFT_SHIFT: {
                    break;
                }
                case DROP_ONE: {
                    if (clicked.isEmpty()) break;
                    this.sub(action.slot, clicked, 1);
                    break;
                }
                case DROP_ALL: {
                    this.setItem(action.slot, GeyserItemStack.EMPTY);
                }
            }
        }
    }

    private void sendSelectedBundleSlot(int slot) {
        this.session.sendDownstreamGamePacket(new ServerboundSelectBundleItemPacket(slot, this.desiredBundleSlot));
    }

    private void swap(int sourceSlot, int destSlot, GeyserItemStack sourceItem) {
        GeyserItemStack destinationItem = this.getItem(destSlot);
        this.setItem(sourceSlot, destinationItem);
        this.setItem(destSlot, sourceItem);
    }

    private int stateIdHack(ClickAction action) {
        int stateId = this.inventory.getNextStateId() != -1 ? this.inventory.getNextStateId() : this.inventory.getStateId();
        if (this.inventory.getContainerType() == ContainerType.CRAFTING && CraftingInventoryTranslator.isCraftingGrid(action.slot)) {
            int stateIdIncrements;
            GeyserItemStack clicked = this.getItem(action.slot);
            if (action.click == Click.LEFT) {
                stateIdIncrements = !clicked.isEmpty() && !InventoryUtils.canStack(this.simulatedCursor, clicked) ? 2 : 1;
            } else if (action.click == Click.RIGHT) {
                stateIdIncrements = 1;
            } else if (action.click.actionType == ContainerActionType.MOVE_TO_HOTBAR_SLOT) {
                stateIdIncrements = 1;
            } else {
                if (this.session.getGeyser().config().debugMode()) {
                    this.session.getGeyser().getLogger().debug("Not sure how to handle state ID hack in crafting table: " + String.valueOf(this.plan));
                }
                stateIdIncrements = 1;
            }
            this.inventory.incrementStateId(stateIdIncrements);
        }
        return stateId;
    }

    private void reduceCraftingGrid(boolean makeAll) {
        int i;
        int crafted;
        if (this.gridSize == -1) {
            return;
        }
        if (!makeAll) {
            crafted = 1;
        } else {
            crafted = 0;
            for (i = 0; i < this.gridSize; ++i) {
                GeyserItemStack item = this.getItem(i + 1);
                if (item.isEmpty()) continue;
                if (crafted == 0) {
                    crafted = item.getAmount();
                }
                crafted = Math.min(crafted, item.getAmount());
            }
        }
        for (i = 0; i < this.gridSize; ++i) {
            int slot = i + 1;
            GeyserItemStack item = this.getItem(slot);
            if (item.isEmpty()) continue;
            this.sub(slot, item, crafted);
        }
    }

    @Contract(value="-> new")
    public IntSet getAffectedSlots() {
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        for (ClickAction action : this.plan) {
            if (this.translator.getSlotType(action.slot) == SlotType.OUTPUT || action.slot == -999) continue;
            affectedSlots.add(action.slot);
            if (action.click.actionType != ContainerActionType.MOVE_TO_HOTBAR_SLOT) continue;
            affectedSlots.add(this.inventory.getOffsetForHotbar(((MoveToHotbarAction)action.click.action).ordinal()));
        }
        return affectedSlots;
    }

    private record ClickAction(Click click, int slot, boolean force) {
    }
}

