/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundRenameItemPacket;

public class AnvilContainer
extends Container {
    private int javaLevelCost = 0;
    private boolean useJavaLevelCost = false;
    private @Nullable String newName = null;
    private GeyserItemStack lastInput = GeyserItemStack.EMPTY;
    private GeyserItemStack lastMaterial = GeyserItemStack.EMPTY;
    private int lastTargetSlot = -1;

    public AnvilContainer(GeyserSession session, String title, int id, int size, ContainerType containerType) {
        super(session, title, id, size, containerType);
    }

    public String checkForRename(GeyserSession session, String rename) {
        String correctRename;
        String plainNewName;
        this.newName = rename;
        Component originalName = this.getInput().getComponent(DataComponentTypes.CUSTOM_NAME);
        String plainOriginalName = MessageTranslator.convertToPlainText(originalName, session.locale());
        if (!plainOriginalName.equals(plainNewName = MessageTranslator.convertToPlainText(rename))) {
            correctRename = plainNewName;
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(plainNewName);
            session.sendDownstreamGamePacket(renameItemPacket);
        } else {
            correctRename = originalName != null ? MessageTranslator.convertMessage(originalName, session.locale()) : "";
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(plainOriginalName);
            session.sendDownstreamGamePacket(renameItemPacket);
        }
        this.useJavaLevelCost = false;
        return correctRename;
    }

    public GeyserItemStack getInput() {
        return this.getItem(0);
    }

    public GeyserItemStack getMaterial() {
        return this.getItem(1);
    }

    public GeyserItemStack getResult() {
        return this.getItem(2);
    }

    @Generated
    public int getJavaLevelCost() {
        return this.javaLevelCost;
    }

    @Generated
    public boolean isUseJavaLevelCost() {
        return this.useJavaLevelCost;
    }

    @Generated
    public @Nullable String getNewName() {
        return this.newName;
    }

    @Generated
    public GeyserItemStack getLastInput() {
        return this.lastInput;
    }

    @Generated
    public GeyserItemStack getLastMaterial() {
        return this.lastMaterial;
    }

    @Generated
    public int getLastTargetSlot() {
        return this.lastTargetSlot;
    }

    @Generated
    public void setJavaLevelCost(int javaLevelCost) {
        this.javaLevelCost = javaLevelCost;
    }

    @Generated
    public void setUseJavaLevelCost(boolean useJavaLevelCost) {
        this.useJavaLevelCost = useJavaLevelCost;
    }

    @Generated
    public void setNewName(@Nullable String newName) {
        this.newName = newName;
    }

    @Generated
    public void setLastInput(GeyserItemStack lastInput) {
        this.lastInput = lastInput;
    }

    @Generated
    public void setLastMaterial(GeyserItemStack lastMaterial) {
        this.lastMaterial = lastMaterial;
    }

    @Generated
    public void setLastTargetSlot(int lastTargetSlot) {
        this.lastTargetSlot = lastTargetSlot;
    }
}

