/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandExecutor;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.Command;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.CommandManager;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.description.CommandDescription;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.standard.StringParser;
import org.geysermc.geyser.session.GeyserSession;

public abstract class GeyserExtensionCommand
extends GeyserCommand {
    private final Extension extension;
    private final String rootCommand;

    public GeyserExtensionCommand(@NonNull Extension extension, @NonNull String name, @NonNull String description, @NonNull String permission, @Nullable TriState permissionDefault, boolean playerOnly, boolean bedrockOnly) {
        super(name, description, permission, permissionDefault, playerOnly, bedrockOnly);
        this.extension = extension;
        this.rootCommand = Objects.requireNonNull(extension.rootCommand());
        if (this.rootCommand.isBlank()) {
            throw new IllegalStateException("rootCommand of extension " + extension.name() + " may not be blank");
        }
    }

    public final Extension extension() {
        return this.extension;
    }

    @Override
    public final String rootCommand() {
        return this.rootCommand;
    }

    public static class Builder<T extends CommandSource>
    implements Command.Builder<T> {
        private final @NonNull Extension extension;
        private @Nullable Class<? extends T> sourceType;
        private @Nullable String name;
        private @NonNull String description = "";
        private @NonNull String permission = "";
        private @Nullable TriState permissionDefault;
        private @Nullable List<String> aliases;
        private boolean suggestedOpOnly = false;
        private boolean playerOnly = false;
        private boolean bedrockOnly = false;
        private @Nullable CommandExecutor<T> executor;

        public Builder(@NonNull Extension extension) {
            this.extension = Objects.requireNonNull(extension);
        }

        @Override
        public Command.Builder<T> source(@NonNull Class<? extends T> sourceType) {
            this.sourceType = Objects.requireNonNull(sourceType, "command source type");
            return this;
        }

        @Override
        public Builder<T> name(@NonNull String name) {
            this.name = Objects.requireNonNull(name, "command name");
            return this;
        }

        @Override
        public Builder<T> description(@NonNull String description) {
            this.description = Objects.requireNonNull(description, "command description");
            return this;
        }

        @Override
        public Builder<T> permission(@NonNull String permission) {
            this.permission = Objects.requireNonNull(permission, "command permission");
            return this;
        }

        @Override
        public Builder<T> permission(@NonNull String permission, @NonNull TriState defaultValue) {
            this.permission = Objects.requireNonNull(permission, "command permission");
            this.permissionDefault = Objects.requireNonNull(defaultValue, "command permission defaultValue");
            return this;
        }

        @Override
        public Builder<T> aliases(@NonNull List<String> aliases) {
            this.aliases = Objects.requireNonNull(aliases, "command aliases");
            return this;
        }

        @Override
        public Builder<T> suggestedOpOnly(boolean suggestedOpOnly) {
            this.suggestedOpOnly = suggestedOpOnly;
            if (suggestedOpOnly) {
                this.permissionDefault = TriState.NOT_SET;
            }
            return this;
        }

        @Override
        public Builder<T> executableOnConsole(boolean executableOnConsole) {
            this.playerOnly = !executableOnConsole;
            return this;
        }

        @Override
        public Command.Builder<T> playerOnly(boolean playerOnly) {
            this.playerOnly = playerOnly;
            return this;
        }

        @Override
        public Builder<T> bedrockOnly(boolean bedrockOnly) {
            this.bedrockOnly = bedrockOnly;
            return this;
        }

        @Override
        public Builder<T> executor(@NonNull CommandExecutor<T> executor) {
            this.executor = Objects.requireNonNull(executor, "command executor");
            return this;
        }

        @Override
        public @NonNull GeyserExtensionCommand build() {
            final Class<? extends T> sourceType = this.sourceType;
            final boolean suggestedOpOnly = this.suggestedOpOnly;
            final CommandExecutor<T> executor = this.executor;
            if (this.name == null) {
                throw new IllegalArgumentException("name was not provided for a command in extension " + this.extension.name());
            }
            if (sourceType == null) {
                throw new IllegalArgumentException("Source type was not defined for command " + this.name + " in extension " + this.extension.name());
            }
            if (executor == null) {
                throw new IllegalArgumentException("Command executor was not defined for command " + this.name + " in extension " + this.extension.name());
            }
            boolean bedrockOnly = this.bedrockOnly || GeyserConnection.class.isAssignableFrom(sourceType);
            GeyserExtensionCommand command = new GeyserExtensionCommand(this.extension, this.name, this.description, this.permission, this.permissionDefault, this.playerOnly, bedrockOnly){

                @Override
                public void register(CommandManager<GeyserCommandSource> manager) {
                    manager.command(this.baseBuilder(manager).optional("args", StringParser.greedyStringParser()).handler(this::execute));
                }

                @Override
                protected Command.Builder.Applicable<GeyserCommandSource> meta() {
                    return builder -> builder.commandDescription(CommandDescription.commandDescription(description));
                }

                @Override
                public void execute(CommandContext<GeyserCommandSource> context) {
                    GeyserCommandSource source = context.sender();
                    String[] args = context.getOrDefault("args", " ").split(" ");
                    if (sourceType.isInstance(source)) {
                        executor.execute(source, this, args);
                        return;
                    }
                    @Nullable GeyserSession session = source.connection();
                    if (sourceType.isInstance(session)) {
                        executor.execute(session, this, args);
                        return;
                    }
                    source.sendMessage("You must be a " + sourceType.getSimpleName() + " to run this command.");
                }

                @Override
                public boolean isSuggestedOpOnly() {
                    return suggestedOpOnly;
                }
            };
            if (this.aliases != null) {
                command.aliases = new ArrayList<String>(this.aliases);
            }
            return command;
        }
    }
}

