/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import lombok.Generated;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.ThrowableItemEntity;
import org.geysermc.geyser.entity.type.living.animal.TemperatureVariantAnimal;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public class ThrowableEggEntity
extends ThrowableItemEntity {
    private GeyserItemStack itemStack = GeyserItemStack.of(Items.EGG.javaId(), 1);

    public ThrowableEggEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        GeyserItemStack stack = GeyserItemStack.from(entityMetadata.getValue());
        TemperatureVariantAnimal.TEMPERATE_VARIANT_PROPERTY.apply(this.propertyManager, ThrowableEggEntity.getVariantOrFallback(this.session, stack));
        this.updateBedrockEntityProperties();
        this.itemStack = stack;
    }

    private static TemperatureVariantAnimal.BuiltInVariant getVariantOrFallback(GeyserSession session, GeyserItemStack stack) {
        Holder<Key> holder = stack.getComponent(DataComponentTypes.CHICKEN_VARIANT);
        if (holder != null) {
            Key chickenVariant = holder.getOrCompute(id -> JavaRegistries.CHICKEN_VARIANT.key(session, id));
            for (TemperatureVariantAnimal.BuiltInVariant variant : TemperatureVariantAnimal.BuiltInVariant.values()) {
                if (!chickenVariant.asMinimalString().equalsIgnoreCase(variant.name())) continue;
                return variant;
            }
        }
        return TemperatureVariantAnimal.BuiltInVariant.TEMPERATE;
    }

    @Generated
    public GeyserItemStack getItemStack() {
        return this.itemStack;
    }
}

