/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.api.entity.data.GeyserEntityDataType;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.property.BatchPropertyUpdater;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.entity.BedrockEntityDefinition;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.entity.GeyserDirtyMetadata;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.entity.properties.GeyserEntityPropertyManager;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Leashable;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.impl.entity.GeyserEntityDataImpl;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class Entity
implements GeyserEntity {
    private static final boolean PRINT_ENTITY_SPAWN_DEBUG = Boolean.parseBoolean(System.getProperty("Geyser.PrintEntitySpawnDebug", "false"));
    protected final GeyserSession session;
    protected BedrockEntityDefinition bedrockDefinition;
    protected EntityTypeDefinition<?> javaTypeDefinition;
    protected int entityId;
    protected final long geyserId;
    protected UUID uuid;
    protected String nametag = "";
    private Vector3f position;
    protected Vector3f motion;
    protected float yaw;
    protected float pitch;
    protected float headYaw;
    protected boolean onGround;
    protected boolean valid;
    private float boundingBoxHeight;
    private float boundingBoxWidth;
    protected String displayName;
    protected boolean silent = false;
    protected List<Entity> passengers = Collections.emptyList();
    protected Entity vehicle;
    protected final GeyserDirtyMetadata dirtyMetadata = new GeyserDirtyMetadata();
    protected final Map<EntityDataType<?>, Object> metadata = new Object2ObjectLinkedOpenHashMap();
    protected final EnumMap<EntityFlag, Boolean> flags = new EnumMap(EntityFlag.class);
    private boolean flagsDirty = false;
    protected float width;
    protected float height;
    protected float offset;
    protected final @Nullable GeyserEntityPropertyManager propertyManager;

    public Entity(EntitySpawnContext context) {
        this.session = context.session();
        this.javaTypeDefinition = context.entityTypeDefinition();
        this.bedrockDefinition = context.bedrockEntityDefinition();
        this.displayName = this.standardDisplayName();
        this.entityId = context.javaId();
        this.geyserId = context.geyserId();
        this.uuid = context.uuid();
        this.motion = context.motion();
        this.yaw = context.yaw();
        this.pitch = context.pitch();
        this.headYaw = context.headYaw();
        this.width = context.width();
        this.height = context.height();
        this.offset = context.offset();
        this.valid = false;
        this.propertyManager = this.bedrockDefinition.registeredProperties().isEmpty() ? null : new GeyserEntityPropertyManager(this.bedrockDefinition.registeredProperties());
        this.setPosition(context.position());
        this.setAirSupply(this.getMaxAir());
        this.initializeMetadata();
    }

    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.width));
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.height));
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(1.0f));
        this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)0);
        this.dirtyMetadata.put(EntityDataTypes.AIR_SUPPLY_MAX, this.getMaxAir());
        this.setDimensionsFromPose(Pose.STANDING);
        this.setFlag(EntityFlag.HAS_GRAVITY, true);
        this.setFlag(EntityFlag.HAS_COLLISION, true);
        this.setFlag(EntityFlag.CAN_SHOW_NAME, true);
        this.setFlag(EntityFlag.CAN_CLIMB, true);
        this.setFlag(EntityFlag.HIDDEN_WHEN_INVISIBLE, true);
        this.setClientSideSilent();
    }

    protected void setClientSideSilent() {
        this.setFlag(EntityFlag.SILENT, true);
    }

    public void spawnEntity() {
        AddEntityPacket addEntityPacket = new AddEntityPacket();
        addEntityPacket.setIdentifier(this.bedrockDefinition.identifier().toString());
        addEntityPacket.setRuntimeEntityId(this.geyserId);
        addEntityPacket.setUniqueEntityId(this.geyserId);
        addEntityPacket.setPosition(this.bedrockPosition());
        addEntityPacket.setMotion(this.motion);
        addEntityPacket.setRotation(Vector2f.from(this.pitch, this.yaw));
        addEntityPacket.setHeadRotation(this.headYaw);
        addEntityPacket.setBodyRotation(this.yaw);
        addEntityPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addEntityPacket.getMetadata());
        if (this.propertyManager != null) {
            this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
            this.propertyManager.applyFloatProperties(addEntityPacket.getProperties().getFloatProperties());
        }
        this.addAdditionalSpawnData(addEntityPacket);
        this.valid = true;
        this.session.sendUpstreamPacket(addEntityPacket);
        this.flagsDirty = false;
        if (this.session.getGeyser().config().debugMode() && PRINT_ENTITY_SPAWN_DEBUG) {
            this.session.getGeyser().getLogger().debug("Spawned entity " + String.valueOf(this.javaTypeDefinition.type()) + " at location " + String.valueOf(this.position) + " with id " + this.geyserId + " (java id " + this.entityId + ")");
        }
    }

    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
    }

    public void despawnEntity() {
        if (!this.valid) {
            return;
        }
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            passenger.setVehicle(null);
            passenger.setFlag(EntityFlag.RIDING, false);
            passenger.updateBedrockMetadata();
        }
        RemoveEntityPacket removeEntityPacket = new RemoveEntityPacket();
        removeEntityPacket.setUniqueEntityId(this.geyserId);
        this.session.sendUpstreamPacket(removeEntityPacket);
        this.valid = false;
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
    }

    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        Entity entity = this;
        if (entity instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)entity);
            if (clientVehicle.isClientControlled()) {
                return;
            }
            clientVehicle.getVehicleComponent().moveRelative(relX, relY, relZ);
        }
        this.setPosition(this.position.add(relX, relY, relZ));
        MoveEntityDeltaPacket moveEntityPacket = new MoveEntityDeltaPacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        if (relX != 0.0) {
            moveEntityPacket.setX(this.bedrockPosition().getX());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
        }
        if (relY != 0.0) {
            moveEntityPacket.setY(this.bedrockPosition().getY());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
        }
        if (relZ != 0.0) {
            moveEntityPacket.setZ(this.bedrockPosition().getZ());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
        }
        if (pitch != this.pitch) {
            this.pitch = pitch;
            moveEntityPacket.setPitch(pitch);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
        }
        if (yaw != this.yaw) {
            this.yaw = yaw;
            moveEntityPacket.setYaw(yaw);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
        }
        if (headYaw != this.headYaw) {
            this.headYaw = headYaw;
            moveEntityPacket.setHeadYaw(headYaw);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
        }
        this.setOnGround(isOnGround);
        if (isOnGround) {
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void moveAbsolute(Vector3f javaPosition, float yaw, float pitch, boolean isOnGround, boolean teleported) {
        this.moveAbsolute(javaPosition, yaw, pitch, this.getHeadYaw(), isOnGround, teleported);
    }

    public void moveAbsolute(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.moveAbsoluteRaw(javaPosition, yaw, pitch, headYaw, isOnGround, teleported);
    }

    public void moveAbsoluteRaw(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(javaPosition);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setPosition(this.bedrockPosition());
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void teleport(Vector3f position, float yaw, float pitch, boolean isOnGround) {
        this.moveAbsolute(position, yaw, pitch, yaw, isOnGround, false);
    }

    public void updateHeadLookRotation(float headYaw) {
        this.moveRelativeRaw(0.0, 0.0, 0.0, this.getYaw(), this.getPitch(), headYaw, this.isOnGround());
    }

    public void updatePositionAndRotation(double moveX, double moveY, double moveZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(moveX, moveY, moveZ, yaw, pitch, this.getHeadYaw(), isOnGround);
    }

    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.updatePositionAndRotation(0.0, 0.0, 0.0, yaw, pitch, isOnGround);
    }

    public final boolean getFlag(EntityFlag flag) {
        Boolean value = this.flags.get((Object)flag);
        return value != null && value != false;
    }

    public final void setFlag(EntityFlag flag, boolean value) {
        Boolean previous = this.flags.get((Object)flag);
        if (previous == null || value != previous) {
            this.flagsDirty = true;
        }
        this.flags.put(flag, value);
    }

    public void updateBedrockMetadata() {
        if (!this.isValid()) {
            return;
        }
        if (this.dirtyMetadata.hasEntries() || this.flagsDirty || this.propertyManager != null && this.propertyManager.hasProperties()) {
            SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
            entityDataPacket.setRuntimeEntityId(this.geyserId);
            if (this.flagsDirty) {
                entityDataPacket.getMetadata().putFlags(this.flags);
                this.flagsDirty = false;
            }
            this.dirtyMetadata.apply(entityDataPacket.getMetadata());
            if (this.propertyManager != null && this.propertyManager.hasProperties()) {
                this.propertyManager.applyIntProperties(entityDataPacket.getProperties().getIntProperties());
                this.propertyManager.applyFloatProperties(entityDataPacket.getProperties().getFloatProperties());
            }
            this.session.sendUpstreamPacket(entityDataPacket);
        }
    }

    public void updateBedrockEntityProperties() {
        if (!this.valid) {
            return;
        }
        if (this.propertyManager != null && this.propertyManager.hasProperties()) {
            SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
            entityDataPacket.setRuntimeEntityId(this.geyserId);
            this.propertyManager.applyIntProperties(entityDataPacket.getProperties().getIntProperties());
            this.propertyManager.applyFloatProperties(entityDataPacket.getProperties().getFloatProperties());
            this.session.sendUpstreamPacket(entityDataPacket);
        }
    }

    public void setFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ON_FIRE, (xd & 1) == 1 && !this.getFlag(EntityFlag.FIRE_IMMUNE));
        this.setSneaking((xd & 2) == 2);
        this.setSprinting((xd & 8) == 8);
        this.setGliding((xd & 0x80) == 128);
        this.setInvisible((xd & 0x20) == 32);
    }

    protected void setInvisible(boolean value) {
        this.setFlag(EntityFlag.INVISIBLE, value);
    }

    protected void setGliding(boolean value) {
        this.setFlag(EntityFlag.GLIDING, value);
    }

    protected void setSprinting(boolean value) {
        this.setFlag(EntityFlag.SPRINTING, value);
    }

    protected void setSneaking(boolean value) {
        this.setFlag(EntityFlag.SNEAKING, value);
    }

    public final void setAir(IntEntityMetadata entityMetadata) {
        this.setAirSupply(entityMetadata.getPrimitiveValue());
    }

    protected void setAirSupply(int amount) {
        this.dirtyMetadata.put(EntityDataTypes.AIR_SUPPLY, (short)MathUtils.constrain(amount, 0, this.getMaxAir()));
    }

    protected short getMaxAir() {
        return 300;
    }

    public String teamIdentifier() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        Optional<Component> name = entityMetadata.getValue();
        if (name.isPresent()) {
            String displayName;
            this.displayName = displayName = MessageTranslator.convertMessage(name.get(), this.session.locale());
            this.setNametag(displayName, true);
            return;
        }
        this.displayName = this.standardDisplayName();
        this.setNametag(null, true);
    }

    protected String standardDisplayName() {
        return EntityUtils.translatedEntityName(this.javaTypeDefinition.type(), this.session);
    }

    protected void setNametag(@Nullable String nametag, boolean fromDisplayName) {
        Team team;
        if (nametag != null && fromDisplayName && (team = this.session.getWorldCache().getScoreboard().getTeamFor(this.teamIdentifier())) != null) {
            this.updateNametag(team);
            return;
        }
        if (nametag == null) {
            nametag = "";
        }
        boolean changed = !Objects.equals(this.nametag, nametag);
        this.nametag = nametag;
        if (!changed) {
            return;
        }
        this.dirtyMetadata.put(EntityDataTypes.NAME, nametag);
        this.scoreVisibility(!nametag.isEmpty());
    }

    public void updateNametag(@Nullable Team team) {
        this.updateNametag(team, true);
    }

    protected void updateNametag(@Nullable Team team, boolean visible) {
        if (team != null) {
            String newNametag = visible ? team.displayName(this.getDisplayName()) : "";
            this.setNametag(newNametag, false);
            return;
        }
        this.setNametag(null, false);
    }

    protected void scoreVisibility(boolean show) {
    }

    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)(entityMetadata.getPrimitiveValue() ? 1 : 0));
    }

    public final void setSilent(BooleanEntityMetadata entityMetadata) {
        this.silent = entityMetadata.getPrimitiveValue();
    }

    public void setGravity(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.HAS_GRAVITY, !entityMetadata.getPrimitiveValue());
    }

    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.SLEEPING, pose.equals((Object)Pose.SLEEPING));
        this.setFlag(EntityFlag.SWIMMING, pose.equals((Object)Pose.SWIMMING));
        this.setDimensionsFromPose(pose);
    }

    protected void setDimensionsFromPose(Pose pose) {
        this.setBoundingBoxHeight(this.height);
        this.setBoundingBoxWidth(this.width);
    }

    public boolean setBoundingBoxHeight(float height) {
        if (height != this.boundingBoxHeight) {
            this.boundingBoxHeight = height;
            this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.boundingBoxHeight));
            this.updatePassengerOffsets();
            return true;
        }
        return false;
    }

    public void setBoundingBoxWidth(float width) {
        if (width != this.boundingBoxWidth) {
            this.boundingBoxWidth = width;
            this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.boundingBoxWidth));
        }
    }

    public float setFreezing(IntEntityMetadata entityMetadata) {
        int freezingTicks = Math.min(entityMetadata.getPrimitiveValue(), 140);
        float freezingPercentage = (float)freezingTicks / 140.0f;
        this.dirtyMetadata.put(EntityDataTypes.FREEZING_EFFECT_STRENGTH, Float.valueOf(freezingPercentage));
        return freezingPercentage;
    }

    public void setRiderSeatPosition(Vector3f position) {
        this.dirtyMetadata.put(EntityDataTypes.SEAT_OFFSET, position);
    }

    protected boolean isShaking() {
        return false;
    }

    public boolean doesJumpDismount() {
        return true;
    }

    public Vector3f getBedrockRotation() {
        return Vector3f.from(this.getPitch(), this.getYaw(), this.getHeadYaw());
    }

    protected void updatePassengerOffsets() {
        for (int i = 0; i < this.passengers.size(); ++i) {
            Entity passenger = this.passengers.get(i);
            if (passenger == null) continue;
            boolean rider = i == 0;
            EntityUtils.updateMountOffset(passenger, this, rider, true, i, this.passengers.size());
            passenger.updateBedrockMetadata();
        }
    }

    protected void updateMountOffset() {
        if (this.vehicle != null) {
            boolean rider = this.vehicle.getPassengers().get(0) == this;
            EntityUtils.updateMountOffset(this, this.vehicle, rider, true, this.vehicle.getPassengers().indexOf(this), this.vehicle.getPassengers().size());
            this.updateBedrockMetadata();
        }
    }

    @Override
    public int javaId() {
        return this.entityId;
    }

    public boolean isAlive() {
        return this.valid;
    }

    public Vector3f bedrockPosition() {
        if (this.offset == 0.0f) {
            return this.position;
        }
        return this.position.up(this.offset);
    }

    public final void updateInteractiveTag() {
        Hand hand;
        InteractiveTag tag = InteractiveTag.NONE;
        Hand[] handArray = EntityUtils.HANDS;
        int n = handArray.length;
        for (int i = 0; i < n && (tag = this.testInteraction(hand = handArray[i])) == InteractiveTag.NONE; ++i) {
        }
        this.session.getPlayerEntity().getDirtyMetadata().put(EntityDataTypes.INTERACT_TEXT, tag.getValue());
        this.session.getPlayerEntity().updateBedrockMetadata();
    }

    protected InteractiveTag testInteraction(Hand hand) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.leashHolderBedrockId() == this.session.getPlayerEntity().geyserId()) {
                return InteractiveTag.REMOVE_LEASH;
            }
            if (this.session.getPlayerInventory().getItemInHand(hand).is(Items.LEAD) && leashable.canBeLeashed()) {
                return InteractiveTag.LEASH;
            }
        }
        return InteractiveTag.NONE;
    }

    public InteractionResult interact(Hand hand) {
        Entity entity;
        Item itemInHand = this.session.getPlayerInventory().getItemInHand(hand).asItem();
        if (itemInHand == Items.SHEARS) {
            if (this.hasLeashesToDrop()) {
                return InteractionResult.SUCCESS;
            }
            Entity entity2 = this;
            if (entity2 instanceof MobEntity) {
                MobEntity mob = (MobEntity)entity2;
                if (!this.session.isSneaking() && mob.canShearEquipment()) {
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.leashHolderBedrockId() == this.session.getPlayerEntity().geyserId()) {
                return InteractionResult.SUCCESS;
            }
            if (this.session.getPlayerInventory().getItemInHand(hand).is(Items.LEAD) && !(this.session.getEntityCache().getEntityByGeyserId(leashable.leashHolderBedrockId()) instanceof PlayerEntity)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean hasLeashesToDrop() {
        Leashable leashable;
        BoundingBox searchBB = new BoundingBox(this.position.getX(), this.position.getY(), this.position.getZ(), 32.0, 32.0, 32.0);
        List<Leashable> leashedInRange = this.session.getEntityCache().getEntities().values().stream().filter(entity -> {
            Leashable leashablex;
            return entity instanceof Leashable && (leashablex = (Leashable)((Object)entity)).leashHolderBedrockId() == this.geyserId();
        }).filter(entity -> {
            BoundingBox leashedBB = new BoundingBox(entity.position.toDouble(), entity.boundingBoxWidth, entity.boundingBoxHeight, entity.boundingBoxWidth);
            return searchBB.checkIntersection(leashedBB);
        }).map(Leashable.class::cast).toList();
        boolean found = !leashedInRange.isEmpty();
        Entity entity2 = this;
        if (entity2 instanceof Leashable && (leashable = (Leashable)((Object)entity2)).isLeashed()) {
            found = true;
        }
        return found;
    }

    public InteractionResult interactAt(Hand hand) {
        return InteractionResult.PASS;
    }

    public final void playEntityEvent(EntityEventType type) {
        this.playEntityEvent(type, 0);
    }

    public final void playEntityEvent(EntityEventType type, int data) {
        EntityEventPacket packet = new EntityEventPacket();
        packet.setRuntimeEntityId(this.geyserId);
        packet.setType(type);
        packet.setData(data);
        this.session.sendUpstreamPacket(packet);
    }

    @Override
    public void updatePropertiesBatched(Consumer<BatchPropertyUpdater> consumer, boolean immediate) {
        if (this.propertyManager == null) {
            throw new IllegalArgumentException("Given entity has no registered properties!");
        }
        Objects.requireNonNull(consumer);
        final GeyserEntityProperties propertyDefinitions = this.bedrockDefinition.registeredProperties();
        consumer.accept(new BatchPropertyUpdater(){

            @Override
            public <T> void update(@NonNull GeyserEntityProperty<T> property, @Nullable T value) {
                Objects.requireNonNull(property, "property must not be null!");
                if (!(property instanceof PropertyType)) {
                    throw new IllegalArgumentException("Invalid property implementation! Got: " + property.getClass().getSimpleName());
                }
                PropertyType propertyType = (PropertyType)property;
                int index = propertyDefinitions.getPropertyIndex(property.identifier().toString());
                if (index < 0) {
                    throw new IllegalArgumentException("No property with the name " + String.valueOf(property.identifier()) + " has been registered.");
                }
                PropertyType<?, ?> expectedProperty = propertyDefinitions.getProperties().get(index);
                if (!expectedProperty.equals(propertyType)) {
                    throw new IllegalArgumentException("The supplied property was not registered with this entity type!");
                }
                propertyType.apply(Entity.this.propertyManager, value);
            }
        });
        if (this.propertyManager.hasProperties()) {
            if (immediate) {
                SetEntityDataPacket packet = new SetEntityDataPacket();
                packet.setRuntimeEntityId(this.geyserId());
                this.propertyManager.applyFloatProperties(packet.getProperties().getFloatProperties());
                this.propertyManager.applyIntProperties(packet.getProperties().getIntProperties());
                this.session.sendUpstreamPacketImmediately(packet);
            } else {
                this.session.getEntityCache().markDirty(this);
            }
        }
    }

    public void offset(float offset, boolean teleport) {
        this.offset = offset;
        if (this.isValid() && teleport) {
            this.moveRelativeRaw(0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, this.isOnGround());
        }
    }

    @Override
    public @NonNull GeyserEntityDefinition definition() {
        return this.bedrockDefinition;
    }

    @Override
    public @NonNull Vector3f position() {
        return this.position;
    }

    @Override
    public <T> void update(@NonNull GeyserEntityDataType<T> dataType, @Nullable T value) {
        if (!(dataType instanceof GeyserEntityDataImpl)) {
            throw new IllegalArgumentException("Invalid data type: " + dataType.getClass().getSimpleName());
        }
        GeyserEntityDataImpl geyserEntityDataImpl = (GeyserEntityDataImpl)dataType;
        geyserEntityDataImpl.update(this, value);
        this.session.getEntityCache().markDirty(this);
    }

    @Override
    public <T> T value(@NonNull GeyserEntityDataType<T> dataType) {
        if (dataType instanceof GeyserEntityDataImpl) {
            GeyserEntityDataImpl geyserEntityDataImpl = (GeyserEntityDataImpl)dataType;
            return geyserEntityDataImpl.value(this);
        }
        throw new IllegalArgumentException("Invalid data type: " + dataType.getClass().getSimpleName());
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public BedrockEntityDefinition bedrockDefinition() {
        return this.bedrockDefinition;
    }

    @Generated
    public EntityTypeDefinition<?> getJavaTypeDefinition() {
        return this.javaTypeDefinition;
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    @Generated
    public long geyserId() {
        return this.geyserId;
    }

    @Override
    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @Generated
    public String getNametag() {
        return this.nametag;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Vector3f getMotion() {
        return this.motion;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getHeadYaw() {
        return this.headYaw;
    }

    @Generated
    public boolean isOnGround() {
        return this.onGround;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public float getBoundingBoxHeight() {
        return this.boundingBoxHeight;
    }

    @Generated
    public float getBoundingBoxWidth() {
        return this.boundingBoxWidth;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public List<Entity> getPassengers() {
        return this.passengers;
    }

    @Generated
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Generated
    public GeyserDirtyMetadata getDirtyMetadata() {
        return this.dirtyMetadata;
    }

    @Generated
    public Map<EntityDataType<?>, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public float width() {
        return this.width;
    }

    @Generated
    public float height() {
        return this.height;
    }

    @Generated
    public float getOffset() {
        return this.offset;
    }

    @Generated
    public @Nullable GeyserEntityPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    @Generated
    public Entity bedrockDefinition(BedrockEntityDefinition bedrockDefinition) {
        this.bedrockDefinition = bedrockDefinition;
        return this;
    }

    @Generated
    public void setJavaTypeDefinition(EntityTypeDefinition<?> javaTypeDefinition) {
        this.javaTypeDefinition = javaTypeDefinition;
    }

    @Generated
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Generated
    public Entity uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Generated
    public void setMotion(Vector3f motion) {
        this.motion = motion;
    }

    @Generated
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    @Generated
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Generated
    public void setHeadYaw(float headYaw) {
        this.headYaw = headYaw;
    }

    @Generated
    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    @Generated
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Generated
    public void setPassengers(List<Entity> passengers) {
        this.passengers = passengers;
    }

    @Generated
    public void setVehicle(Entity vehicle) {
        this.vehicle = vehicle;
    }

    @Generated
    public Entity width(float width) {
        this.width = width;
        return this;
    }

    @Generated
    public Entity height(float height) {
        this.height = height;
        return this;
    }

    @Generated
    public void setOffset(float offset) {
        this.offset = offset;
    }

    @Generated
    public void setPosition(Vector3f position) {
        this.position = position;
    }

    @Generated
    protected void setFlagsDirty(boolean flagsDirty) {
        this.flagsDirty = flagsDirty;
    }
}

