/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.translator.entity.EntityMetadataTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public class EntityTypeBase<T extends Entity> {
    protected final float width;
    protected final float height;
    protected final float offset;
    protected final List<EntityMetadataTranslator<? super T, ?, ?>> translators;

    public EntityTypeBase(float width, float height, float offset, List<EntityMetadataTranslator<? super T, ?, ?>> translators) {
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.translators = translators;
    }

    public static <T extends Entity> Builder<T> baseBuilder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static <T extends Entity> Builder<T> baseInherited(Class<T> clazz, EntityTypeBase<? super T> parent) {
        return new Builder<T>(parent.width, parent.height, parent.offset, new ObjectArrayList(parent.translators));
    }

    public <M> void translateMetadata(T entity, EntityMetadata<M, ? extends MetadataType<M>> metadata) {
        EntityMetadataTranslator<T, ?, ?> translator = this.translators.get(metadata.getId());
        if (translator == null) {
            return;
        }
        if (translator.acceptedType() != metadata.getType()) {
            GeyserImpl.getInstance().getLogger().warning("Metadata ID " + metadata.getId() + " was received with type " + String.valueOf(metadata.getType()) + " but we expected " + String.valueOf(translator.acceptedType()) + " for " + String.valueOf(((Entity)entity).getJavaTypeDefinition().type()));
            if (GeyserImpl.getInstance().config().debugMode()) {
                GeyserImpl.getInstance().getLogger().debug(metadata.toString());
            }
            return;
        }
        translator.translate(entity, metadata);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityTypeBase)) {
            return false;
        }
        EntityTypeBase other = (EntityTypeBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.width(), other.width()) != 0) {
            return false;
        }
        if (Float.compare(this.height(), other.height()) != 0) {
            return false;
        }
        if (Float.compare(this.offset(), other.offset()) != 0) {
            return false;
        }
        List<EntityMetadataTranslator<T, ?, ?>> this$translators = this.translators();
        List<EntityMetadataTranslator<T, ?, ?>> other$translators = other.translators();
        return !(this$translators == null ? other$translators != null : !((Object)this$translators).equals(other$translators));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityTypeBase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.width());
        result = result * 59 + Float.floatToIntBits(this.height());
        result = result * 59 + Float.floatToIntBits(this.offset());
        List<EntityMetadataTranslator<T, ?, ?>> $translators = this.translators();
        result = result * 59 + ($translators == null ? 43 : ((Object)$translators).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityTypeBase(width=" + this.width() + ", height=" + this.height() + ", offset=" + this.offset() + ", translators=" + String.valueOf(this.translators()) + ")";
    }

    @Generated
    public float width() {
        return this.width;
    }

    @Generated
    public float height() {
        return this.height;
    }

    @Generated
    public float offset() {
        return this.offset;
    }

    @Generated
    public List<EntityMetadataTranslator<? super T, ?, ?>> translators() {
        return this.translators;
    }

    public static class Builder<T extends Entity> {
        protected float width;
        protected float height;
        protected float offset = 1.0E-5f;
        protected final List<EntityMetadataTranslator<? super T, ?, ?>> translators;

        protected Builder() {
            this.translators = new ObjectArrayList();
        }

        protected Builder(Class<T> clazz) {
            this();
        }

        protected Builder(float width, float height, float offset, List<EntityMetadataTranslator<? super T, ?, ?>> translators) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.translators = translators;
        }

        public Builder<T> heightAndWidth(float value) {
            this.height = value;
            this.width = value;
            return this;
        }

        public Builder<T> offset(float offset) {
            this.offset = offset + 1.0E-5f;
            return this;
        }

        public <U, EM extends EntityMetadata<U, ? extends MetadataType<U>>> Builder<T> addTranslator(MetadataType<U> type, BiConsumer<T, EM> translateFunction) {
            this.translators.add(new EntityMetadataTranslator<T, U, EM>(type, translateFunction));
            return this;
        }

        public Builder<T> addTranslator(EntityMetadataTranslator<T, ?, ?> translator) {
            this.translators.add(translator);
            return this;
        }

        public EntityTypeBase<T> build() {
            return new EntityTypeBase<T>(this.width, this.height, this.offset, this.translators);
        }

        @Generated
        public Builder<T> width(float width) {
            this.width = width;
            return this;
        }

        @Generated
        public Builder<T> height(float height) {
            this.height = height;
            return this;
        }
    }
}

