/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundSetTestBlockPacket
implements MinecraftPacket {
    private final Vector3i position;
    private final int mode;
    private final String message;

    public ServerboundSetTestBlockPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.mode = MinecraftTypes.readVarInt(in);
        this.message = MinecraftTypes.readString(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        MinecraftTypes.writeVarInt(out, this.mode);
        MinecraftTypes.writeString(out, this.message);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public int getMode() {
        return this.mode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetTestBlockPacket)) {
            return false;
        }
        ServerboundSetTestBlockPacket other = (ServerboundSetTestBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetTestBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMode();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetTestBlockPacket(position=" + String.valueOf(this.getPosition()) + ", mode=" + this.getMode() + ", message=" + this.getMessage() + ")";
    }

    public @NonNull ServerboundSetTestBlockPacket withPosition(Vector3i position) {
        return this.position == position ? this : new ServerboundSetTestBlockPacket(position, this.mode, this.message);
    }

    public @NonNull ServerboundSetTestBlockPacket withMode(int mode) {
        return this.mode == mode ? this : new ServerboundSetTestBlockPacket(this.position, mode, this.message);
    }

    public @NonNull ServerboundSetTestBlockPacket withMessage(String message) {
        return this.message == message ? this : new ServerboundSetTestBlockPacket(this.position, this.mode, message);
    }

    public ServerboundSetTestBlockPacket(Vector3i position, int mode, String message) {
        this.position = position;
        this.mode = mode;
        this.message = message;
    }
}

