/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeModifiers {
    private final List<Entry> modifiers;

    public ItemAttributeModifiers(List<Entry> modifiers) {
        this.modifiers = List.copyOf(modifiers);
    }

    public List<Entry> getModifiers() {
        return this.modifiers;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemAttributeModifiers)) {
            return false;
        }
        ItemAttributeModifiers other = (ItemAttributeModifiers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Entry> this$modifiers = this.getModifiers();
        List<Entry> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ItemAttributeModifiers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Entry> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ItemAttributeModifiers(modifiers=" + String.valueOf(this.getModifiers()) + ")";
    }

    public @NonNull ItemAttributeModifiers withModifiers(List<Entry> modifiers) {
        return this.modifiers == modifiers ? this : new ItemAttributeModifiers(modifiers);
    }

    public static enum DisplayType {
        DEFAULT,
        HIDDEN,
        OVERRIDE;

        private static final DisplayType[] VALUES;

        public static DisplayType from(int id) {
            return id >= 0 && id < VALUES.length ? VALUES[id] : VALUES[0];
        }

        static {
            VALUES = DisplayType.values();
        }
    }

    public static enum EquipmentSlotGroup {
        ANY,
        MAIN_HAND,
        OFF_HAND,
        HAND,
        FEET,
        LEGS,
        CHEST,
        HEAD,
        ARMOR,
        BODY,
        SADDLE;

        private static final EquipmentSlotGroup[] VALUES;

        public static EquipmentSlotGroup from(int id) {
            return VALUES[id];
        }

        static {
            VALUES = EquipmentSlotGroup.values();
        }
    }

    public static class Display {
        DisplayType type;
        @Nullable
        Component component;

        public static @NonNull DisplayBuilder builder() {
            return new DisplayBuilder();
        }

        public @NonNull DisplayBuilder toBuilder() {
            return new DisplayBuilder().type(this.type).component(this.component);
        }

        public DisplayType getType() {
            return this.type;
        }

        @Nullable
        public Component getComponent() {
            return this.component;
        }

        public void setType(DisplayType type) {
            this.type = type;
        }

        public void setComponent(@Nullable Component component) {
            this.component = component;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Display)) {
                return false;
            }
            Display other = (Display)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DisplayType this$type = this.getType();
            DisplayType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Component this$component = this.getComponent();
            Component other$component = other.getComponent();
            return !(this$component == null ? other$component != null : !this$component.equals(other$component));
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof Display;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DisplayType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Component $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ItemAttributeModifiers.Display(type=" + String.valueOf((Object)this.getType()) + ", component=" + String.valueOf(this.getComponent()) + ")";
        }

        public Display(DisplayType type, @Nullable Component component) {
            this.type = type;
            this.component = component;
        }

        public static class DisplayBuilder {
            private DisplayType type;
            private Component component;

            DisplayBuilder() {
            }

            public @NonNull DisplayBuilder type(DisplayType type) {
                this.type = type;
                return this;
            }

            public @NonNull DisplayBuilder component(@Nullable Component component) {
                this.component = component;
                return this;
            }

            public @NonNull Display build() {
                return new Display(this.type, this.component);
            }

            public @NonNull String toString() {
                return "ItemAttributeModifiers.Display.DisplayBuilder(type=" + String.valueOf((Object)this.type) + ", component=" + String.valueOf(this.component) + ")";
            }
        }
    }

    public static class AttributeModifier {
        private final Key id;
        private final double amount;
        private final ModifierOperation operation;

        public static @NonNull AttributeModifierBuilder builder() {
            return new AttributeModifierBuilder();
        }

        public @NonNull AttributeModifierBuilder toBuilder() {
            return new AttributeModifierBuilder().id(this.id).amount(this.amount).operation(this.operation);
        }

        public Key getId() {
            return this.id;
        }

        public double getAmount() {
            return this.amount;
        }

        public ModifierOperation getOperation() {
            return this.operation;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeModifier)) {
                return false;
            }
            AttributeModifier other = (AttributeModifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
                return false;
            }
            Key this$id = this.getId();
            Key other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ModifierOperation this$operation = this.getOperation();
            ModifierOperation other$operation = other.getOperation();
            return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof AttributeModifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $amount = Double.doubleToLongBits(this.getAmount());
            result = result * 59 + (int)($amount >>> 32 ^ $amount);
            Key $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ModifierOperation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ItemAttributeModifiers.AttributeModifier(id=" + String.valueOf(this.getId()) + ", amount=" + this.getAmount() + ", operation=" + String.valueOf((Object)this.getOperation()) + ")";
        }

        public AttributeModifier(Key id, double amount, ModifierOperation operation) {
            this.id = id;
            this.amount = amount;
            this.operation = operation;
        }

        public static class AttributeModifierBuilder {
            private Key id;
            private double amount;
            private ModifierOperation operation;

            AttributeModifierBuilder() {
            }

            public @NonNull AttributeModifierBuilder id(Key id) {
                this.id = id;
                return this;
            }

            public @NonNull AttributeModifierBuilder amount(double amount) {
                this.amount = amount;
                return this;
            }

            public @NonNull AttributeModifierBuilder operation(ModifierOperation operation) {
                this.operation = operation;
                return this;
            }

            public @NonNull AttributeModifier build() {
                return new AttributeModifier(this.id, this.amount, this.operation);
            }

            public @NonNull String toString() {
                return "ItemAttributeModifiers.AttributeModifier.AttributeModifierBuilder(id=" + String.valueOf(this.id) + ", amount=" + this.amount + ", operation=" + String.valueOf((Object)this.operation) + ")";
            }
        }
    }

    public static class Entry {
        private final int attribute;
        private final AttributeModifier modifier;
        private final EquipmentSlotGroup slot;
        private final Display display;

        public static @NonNull EntryBuilder builder() {
            return new EntryBuilder();
        }

        public @NonNull EntryBuilder toBuilder() {
            return new EntryBuilder().attribute(this.attribute).modifier(this.modifier).slot(this.slot).display(this.display);
        }

        public int getAttribute() {
            return this.attribute;
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public EquipmentSlotGroup getSlot() {
            return this.slot;
        }

        public Display getDisplay() {
            return this.display;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAttribute() != other.getAttribute()) {
                return false;
            }
            AttributeModifier this$modifier = this.getModifier();
            AttributeModifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !((Object)this$modifier).equals(other$modifier)) {
                return false;
            }
            EquipmentSlotGroup this$slot = this.getSlot();
            EquipmentSlotGroup other$slot = other.getSlot();
            if (this$slot == null ? other$slot != null : !((Object)((Object)this$slot)).equals((Object)other$slot)) {
                return false;
            }
            Display this$display = this.getDisplay();
            Display other$display = other.getDisplay();
            return !(this$display == null ? other$display != null : !((Object)this$display).equals(other$display));
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttribute();
            AttributeModifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : ((Object)$modifier).hashCode());
            EquipmentSlotGroup $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : ((Object)((Object)$slot)).hashCode());
            Display $display = this.getDisplay();
            result = result * 59 + ($display == null ? 43 : ((Object)$display).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ItemAttributeModifiers.Entry(attribute=" + this.getAttribute() + ", modifier=" + String.valueOf(this.getModifier()) + ", slot=" + String.valueOf((Object)this.getSlot()) + ", display=" + String.valueOf(this.getDisplay()) + ")";
        }

        public Entry(int attribute, AttributeModifier modifier, EquipmentSlotGroup slot, Display display) {
            this.attribute = attribute;
            this.modifier = modifier;
            this.slot = slot;
            this.display = display;
        }

        public static class EntryBuilder {
            private int attribute;
            private AttributeModifier modifier;
            private EquipmentSlotGroup slot;
            private Display display;

            EntryBuilder() {
            }

            public @NonNull EntryBuilder attribute(int attribute) {
                this.attribute = attribute;
                return this;
            }

            public @NonNull EntryBuilder modifier(AttributeModifier modifier) {
                this.modifier = modifier;
                return this;
            }

            public @NonNull EntryBuilder slot(EquipmentSlotGroup slot) {
                this.slot = slot;
                return this;
            }

            public @NonNull EntryBuilder display(Display display) {
                this.display = display;
                return this;
            }

            public @NonNull Entry build() {
                return new Entry(this.attribute, this.modifier, this.slot, this.display);
            }

            public @NonNull String toString() {
                return "ItemAttributeModifiers.Entry.EntryBuilder(attribute=" + this.attribute + ", modifier=" + String.valueOf(this.modifier) + ", slot=" + String.valueOf((Object)this.slot) + ", display=" + String.valueOf(this.display) + ")";
            }
        }
    }
}

