/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game;

import java.security.PublicKey;
import java.util.Arrays;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class PlayerListEntry {
    @lombok.NonNull
    private final UUID profileId;
    private @Nullable GameProfile profile;
    private boolean listed;
    private int latency;
    private GameMode gameMode;
    private @Nullable Component displayName;
    private boolean showHat;
    private int listOrder;
    private UUID sessionId;
    private long expiresAt;
    private @Nullable PublicKey publicKey;
    private byte @Nullable [] keySignature;

    public PlayerListEntry(UUID profileId) {
        this(profileId, null, false, 0, GameMode.SURVIVAL, null, false, 0, null, 0L, null, null);
    }

    @lombok.NonNull
    public UUID getProfileId() {
        return this.profileId;
    }

    public @Nullable GameProfile getProfile() {
        return this.profile;
    }

    public boolean isListed() {
        return this.listed;
    }

    public int getLatency() {
        return this.latency;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public @Nullable Component getDisplayName() {
        return this.displayName;
    }

    public boolean isShowHat() {
        return this.showHat;
    }

    public int getListOrder() {
        return this.listOrder;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public @Nullable PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte @Nullable [] getKeySignature() {
        return this.keySignature;
    }

    public void setProfile(@Nullable GameProfile profile) {
        this.profile = profile;
    }

    public void setListed(boolean listed) {
        this.listed = listed;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public void setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    public void setShowHat(boolean showHat) {
        this.showHat = showHat;
    }

    public void setListOrder(int listOrder) {
        this.listOrder = listOrder;
    }

    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setPublicKey(@Nullable PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setKeySignature(byte @Nullable [] keySignature) {
        this.keySignature = keySignature;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListEntry)) {
            return false;
        }
        PlayerListEntry other = (PlayerListEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isListed() != other.isListed()) {
            return false;
        }
        if (this.getLatency() != other.getLatency()) {
            return false;
        }
        if (this.isShowHat() != other.isShowHat()) {
            return false;
        }
        if (this.getListOrder() != other.getListOrder()) {
            return false;
        }
        if (this.getExpiresAt() != other.getExpiresAt()) {
            return false;
        }
        UUID this$profileId = this.getProfileId();
        UUID other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !((Object)this$profileId).equals(other$profileId)) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile)) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getKeySignature(), other.getKeySignature());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PlayerListEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isListed() ? 79 : 97);
        result = result * 59 + this.getLatency();
        result = result * 59 + (this.isShowHat() ? 79 : 97);
        result = result * 59 + this.getListOrder();
        long $expiresAt = this.getExpiresAt();
        result = result * 59 + (int)($expiresAt >>> 32 ^ $expiresAt);
        UUID $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : ((Object)$profileId).hashCode());
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeySignature());
        return result;
    }

    public @NonNull String toString() {
        return "PlayerListEntry(profileId=" + String.valueOf(this.getProfileId()) + ", profile=" + String.valueOf(this.getProfile()) + ", listed=" + this.isListed() + ", latency=" + this.getLatency() + ", gameMode=" + String.valueOf(this.getGameMode()) + ", displayName=" + String.valueOf(this.getDisplayName()) + ", showHat=" + this.isShowHat() + ", listOrder=" + this.getListOrder() + ", sessionId=" + String.valueOf(this.getSessionId()) + ", expiresAt=" + this.getExpiresAt() + ", publicKey=" + String.valueOf(this.getPublicKey()) + ", keySignature=" + Arrays.toString(this.getKeySignature()) + ")";
    }

    public PlayerListEntry(@lombok.NonNull UUID profileId, @Nullable GameProfile profile, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, boolean showHat, int listOrder, UUID sessionId, long expiresAt, @Nullable PublicKey publicKey, byte @Nullable [] keySignature) {
        if (profileId == null) {
            throw new NullPointerException("profileId is marked non-null but is null");
        }
        this.profileId = profileId;
        this.profile = profile;
        this.listed = listed;
        this.latency = latency;
        this.gameMode = gameMode;
        this.displayName = displayName;
        this.showHat = showHat;
        this.listOrder = listOrder;
        this.sessionId = sessionId;
        this.expiresAt = expiresAt;
        this.publicKey = publicKey;
        this.keySignature = keySignature;
    }
}

