/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftLoomAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class LoomInventoryTranslator
extends AbstractBlockInventoryTranslator<Container> {
    private static final Tag<BannerPattern> NO_ITEMS_REQUIRED = new Tag<BannerPattern>(JavaRegistries.BANNER_PATTERN, Key.key("no_item_required"));

    public LoomInventoryTranslator() {
        super(4, Blocks.LOOM, ContainerType.LOOM, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    protected boolean shouldRejectItemPlace(GeyserSession session, Container container, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        GeyserItemStack itemStack;
        if (javaDestinationSlot != 1) {
            return false;
        }
        GeyserItemStack geyserItemStack = itemStack = javaSourceSlot == -1 ? session.getPlayerInventory().getCursor() : container.getItem(javaSourceSlot);
        if (itemStack.isEmpty()) {
            return false;
        }
        return !(itemStack.asItem() instanceof DyeItem);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Container container) {
        return action.getType() == ItemStackRequestActionType.CRAFT_LOOM && container.getItem(2).isEmpty();
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, Container container, ItemStackRequest request) {
        ItemStackRequestAction headerData = request.getActions()[0];
        ItemStackRequestAction data = request.getActions()[1];
        if (!(headerData instanceof CraftLoomAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        if (!(data instanceof CraftResultsDeprecatedAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        CraftResultsDeprecatedAction craftData = (CraftResultsDeprecatedAction)data;
        String bedrockPattern = ((CraftLoomAction)headerData).getPatternId();
        BannerPattern requestedPattern = BannerPattern.getByBedrockIdentifier(bedrockPattern);
        if (requestedPattern == null) {
            GeyserImpl.getInstance().getLogger().warning("Unknown Bedrock pattern id: " + bedrockPattern);
            return LoomInventoryTranslator.rejectRequest(request);
        }
        int index = session.getTagCache().get(NO_ITEMS_REQUIRED).indexOf((Object)requestedPattern);
        if (index == -1) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        List<NbtMap> newBlockEntityTag = craftData.getResultItems()[0].getTag().getList("Patterns", NbtType.COMPOUND);
        NbtMap pattern = newBlockEntityTag.get(newBlockEntityTag.size() - 1);
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(container.getJavaId(), index);
        session.sendDownstreamGamePacket(packet);
        GeyserItemStack inputCopy = container.getItem(0).copy(1);
        inputCopy.setNetId(session.getNextItemNetId());
        BannerPatternLayer bannerPatternLayer = BannerItem.getJavaBannerPattern(session, pattern);
        if (bannerPatternLayer != null) {
            ArrayList<BannerPatternLayer> patternsList = new ArrayList<BannerPatternLayer>(inputCopy.getComponentElseGet(DataComponentTypes.BANNER_PATTERNS, ArrayList::new));
            patternsList.add(bannerPatternLayer);
            inputCopy.getOrCreateComponents().put(DataComponentTypes.BANNER_PATTERNS, patternsList);
        }
        container.setItem(3, inputCopy, session);
        return this.translateRequest(session, container, request);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.LOOM_INPUT -> 0;
            case ContainerSlotType.LOOM_DYE -> 1;
            case ContainerSlotType.LOOM_MATERIAL -> 2;
            case ContainerSlotType.LOOM_RESULT, ContainerSlotType.CREATED_OUTPUT -> 3;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, Container container) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.LOOM_INPUT, 9);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.LOOM_DYE, 10);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.LOOM_MATERIAL, 11);
            case 3 -> new BedrockContainerSlot(ContainerSlotType.LOOM_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot, container);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 9;
            case 1 -> 10;
            case 2 -> 11;
            case 3 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 3) {
            return SlotType.OUTPUT;
        }
        return super.getSlotType(javaSlot);
    }

    @Override
    public @Nullable ContainerType closeContainerType(Container container) {
        return null;
    }
}

