/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakDisconnectReason;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.AdvancedChannelInboundHandler;

@ChannelHandler.Sharable
public class DisconnectNotificationHandler
extends AdvancedChannelInboundHandler<EncapsulatedPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(DisconnectNotificationHandler.class);
    public static final DisconnectNotificationHandler INSTANCE = new DisconnectNotificationHandler();
    public static final String NAME = "rak-disconnect-notification-handler";

    @Override
    protected boolean acceptInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!super.acceptInboundMessage(ctx, msg)) {
            return false;
        }
        ByteBuf buf = ((EncapsulatedPacket)((Object)msg)).getBuffer();
        return buf.getUnsignedByte(buf.readerIndex()) == 21;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, EncapsulatedPacket packet) throws Exception {
        ByteBuf buf = packet.getBuffer();
        buf.readUnsignedByte();
        if (log.isTraceEnabled()) {
            log.trace("RakNet Session ({} => {}) by remote peer!", (Object)ctx.channel().localAddress(), (Object)ctx.channel().remoteAddress());
        }
        ctx.fireUserEventTriggered((Object)RakDisconnectReason.CLOSED_BY_REMOTE_PEER);
        ctx.fireChannelInactive();
    }
}

