/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.raphimc.viaproxy.ViaProxy;
import net.raphimc.viaproxy.plugins.ViaProxyPlugin;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.text.AsteriskSerializer;

public class GeyserViaProxyDumpInfo
extends BootstrapDumpInfo {
    private final String platformVersion;
    private final boolean onlineMode = ViaProxy.getConfig().isProxyOnlineMode();
    @AsteriskSerializer.Asterisk(isIp=true)
    private final String serverIP;
    private final int serverPort;
    private final List<BootstrapDumpInfo.PluginInfo> plugins;

    public GeyserViaProxyDumpInfo() {
        this.platformVersion = "3.3.2-SNAPSHOT";
        SocketAddress socketAddress = ViaProxy.getConfig().getBindAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            this.serverIP = inetSocketAddress.getHostString();
            this.serverPort = inetSocketAddress.getPort();
        } else {
            this.serverIP = "unsupported";
            this.serverPort = 0;
        }
        this.plugins = new ArrayList<BootstrapDumpInfo.PluginInfo>();
        for (ViaProxyPlugin plugin : ViaProxy.getPluginManager().getPlugins()) {
            this.plugins.add(new BootstrapDumpInfo.PluginInfo(true, plugin.getName(), plugin.getVersion(), "unknown", Collections.singletonList(plugin.getAuthor())));
        }
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public List<BootstrapDumpInfo.PluginInfo> getPlugins() {
        return this.plugins;
    }
}

