/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.ping;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.NetUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.util.VarInts;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public class GeyserLegacyPingPassthrough
implements IGeyserPingPassthrough,
Runnable {
    private static final byte[] HAPROXY_BINARY_PREFIX = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private final GeyserImpl geyser;
    private GeyserPingInfo pingInfo;

    public GeyserLegacyPingPassthrough(GeyserImpl geyser) {
        this.geyser = geyser;
    }

    public static @Nullable IGeyserPingPassthrough init(GeyserImpl geyser) {
        if (geyser.getConfig().isPassthroughMotd() || geyser.getConfig().isPassthroughPlayerCounts()) {
            GeyserLegacyPingPassthrough pingPassthrough = new GeyserLegacyPingPassthrough(geyser);
            int interval = geyser.getConfig().getPingPassthroughInterval() == 0 ? 1 : geyser.getConfig().getPingPassthroughInterval();
            geyser.getLogger().debug("Scheduling ping passthrough at an interval of " + interval + " second(s).");
            geyser.getScheduledThread().scheduleAtFixedRate(pingPassthrough, 1L, interval, TimeUnit.SECONDS);
            return pingPassthrough;
        }
        return null;
    }

    @Override
    public GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        return this.pingInfo;
    }

    @Override
    public void run() {
        try (Socket socket = new Socket();){
            byte[] buffer;
            String address = this.geyser.getConfig().getRemote().address();
            int port = this.geyser.getConfig().getRemote().port();
            InetSocketAddress endpoint = new InetSocketAddress(address, port);
            socket.connect(endpoint, 5000);
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            try (DataOutputStream handshake = new DataOutputStream(byteArrayStream);){
                handshake.write(0);
                VarInts.writeUnsignedInt(handshake, GameProtocol.getJavaProtocolVersion());
                VarInts.writeUnsignedInt(handshake, address.length());
                handshake.writeBytes(address);
                handshake.writeShort(port);
                VarInts.writeUnsignedInt(handshake, 1L);
            }
            try (DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());){
                if (this.geyser.getConfig().getRemote().isUseProxyProtocol()) {
                    dataOutputStream.write(HAPROXY_BINARY_PREFIX);
                    dataOutputStream.writeByte(0x20 | HAProxyCommand.PROXY.byteValue());
                    dataOutputStream.writeByte(socket.getLocalAddress() instanceof Inet4Address ? HAProxyProxiedProtocol.TCP4.byteValue() : HAProxyProxiedProtocol.TCP6.byteValue());
                    byte[] srcAddrBytes = NetUtil.createByteArrayFromIpAddressString((String)((InetSocketAddress)socket.getLocalSocketAddress()).getAddress().getHostAddress());
                    byte[] dstAddrBytes = NetUtil.createByteArrayFromIpAddressString((String)endpoint.getAddress().getHostAddress());
                    dataOutputStream.writeShort(srcAddrBytes.length + dstAddrBytes.length + 4);
                    dataOutputStream.write(srcAddrBytes);
                    dataOutputStream.write(dstAddrBytes);
                    dataOutputStream.writeShort(((InetSocketAddress)socket.getLocalSocketAddress()).getPort());
                    dataOutputStream.writeShort(port);
                }
                VarInts.writeUnsignedInt(dataOutputStream, byteArrayStream.size());
                dataOutputStream.write(byteArrayStream.toByteArray());
                dataOutputStream.writeByte(1);
                dataOutputStream.writeByte(0);
                try (DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());){
                    VarInts.readUnsignedInt(dataInputStream);
                    VarInts.readUnsignedInt(dataInputStream);
                    int length = VarInts.readUnsignedInt(dataInputStream);
                    buffer = new byte[length];
                    dataInputStream.readFully(buffer);
                    dataOutputStream.writeByte(9);
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeLong(System.currentTimeMillis());
                    VarInts.readUnsignedInt(dataInputStream);
                }
            }
            this.pingInfo = GeyserImpl.JSON_MAPPER.readValue(buffer, GeyserPingInfo.class);
        }
        catch (ConnectException | SocketTimeoutException ex) {
            this.pingInfo = null;
            this.geyser.getLogger().debug("Connection timeout for ping passthrough.");
        }
        catch (JsonParseException | JsonMappingException ex) {
            this.geyser.getLogger().error("Failed to parse json when pinging server!", ex);
        }
        catch (EOFException e) {
            this.pingInfo = null;
            this.geyser.getLogger().warning("Failed to ping the remote Java server! Is it online and configured in Geyser's config?");
        }
        catch (UnknownHostException ex) {
            this.geyser.getLogger().warning("Unable to resolve remote host! Is the remote server down or invalid?");
        }
        catch (IOException e) {
            this.geyser.getLogger().error("IO error while trying to use legacy ping passthrough", e);
        }
    }
}

