/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Filterable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;

public class WrittenBookItem
extends Item {
    public static final int MAXIMUM_PAGE_EDIT_LENGTH = 1024;
    public static final int MAXIMUM_PAGE_COUNT = 100;
    public static final int MAXIMUM_TITLE_LENGTH = 16;

    public WrittenBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        WrittenBookContent bookContent = components.get(DataComponentTypes.WRITTEN_BOOK_CONTENT);
        if (bookContent == null) {
            return;
        }
        ArrayList<NbtMap> bedrockPages = new ArrayList<NbtMap>();
        for (Filterable<Component> page : bookContent.getPages()) {
            NbtMapBuilder pageBuilder = NbtMap.builder();
            pageBuilder.putString("photoname", "");
            pageBuilder.putString("text", MessageTranslator.convertMessage(session, page.getRaw()));
            bedrockPages.add(pageBuilder.build());
        }
        builder.putList("pages", NbtType.COMPOUND, bedrockPages);
        builder.putString("title", bookContent.getTitle().getRaw()).putString("author", bookContent.getAuthor()).putInt("generation", bookContent.getGeneration());
    }
}

