/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.entity.type.living.animal.TropicalFishEntity;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.format.TextDecoration;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class TropicalFishBucketItem
extends Item {
    private static final Style LORE_STYLE = Style.style((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC);

    public TropicalFishBucketItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        builder.putByte("AppendCustomName", (byte)1);
        builder.putString("CustomName", MinecraftLocale.getLocaleString("entity.minecraft.tropical_fish", session.locale()));
        Integer pattern = components.get(DataComponentTypes.TROPICAL_FISH_PATTERN);
        Integer baseColor = components.get(DataComponentTypes.TROPICAL_FISH_BASE_COLOR);
        Integer patternColor = components.get(DataComponentTypes.TROPICAL_FISH_PATTERN_COLOR);
        if ((pattern != null || baseColor != null && patternColor != null) && tooltip.showInTooltip(DataComponentTypes.TROPICAL_FISH_PATTERN)) {
            int packedVariant = TropicalFishBucketItem.getPackedVariant(pattern, baseColor, patternColor);
            List<String> lore = builder.getOrCreateLore();
            int predefinedVariantId = TropicalFishEntity.getPredefinedId(packedVariant);
            if (predefinedVariantId != -1) {
                TranslatableComponent line = Component.translatable("entity.minecraft.tropical_fish.predefined." + predefinedVariantId, LORE_STYLE);
                lore.add(0, MessageTranslator.convertMessage(line, session.locale()));
            } else {
                TranslatableComponent typeTooltip = Component.translatable("entity.minecraft.tropical_fish.type." + TropicalFishEntity.getVariantName(packedVariant), LORE_STYLE);
                lore.add(0, MessageTranslator.convertMessage(typeTooltip, session.locale()));
                if (baseColor != null && patternColor != null) {
                    Component colorTooltip = Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(baseColor.byteValue()), LORE_STYLE);
                    if (!baseColor.equals(patternColor)) {
                        colorTooltip = colorTooltip.append(Component.text(", ", LORE_STYLE)).append(Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(patternColor.byteValue()), LORE_STYLE));
                    }
                    lore.add(1, MessageTranslator.convertMessage(colorTooltip, session.locale()));
                }
            }
        }
    }

    private static int getPackedVariant(Integer pattern, Integer baseColor, Integer patternColor) {
        if (pattern == null) {
            pattern = 0;
        }
        if (baseColor == null) {
            baseColor = 0;
        }
        if (patternColor == null) {
            patternColor = 0;
        }
        return TropicalFishEntity.getPackedVariant(pattern, baseColor, patternColor);
    }
}

