/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.response.result;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.response.FormResponse;
import org.geysermc.cumulus.response.result.ClosedFormResponseResult;
import org.geysermc.cumulus.response.result.InvalidFormResponseResult;
import org.geysermc.cumulus.response.result.ResultType;
import org.geysermc.cumulus.response.result.ValidFormResponseResult;

public interface FormResponseResult<R extends FormResponse> {
    public static <R extends FormResponse> @NonNull ClosedFormResponseResult<R> closed() {
        return ClosedFormResponseResult.instance();
    }

    public static <R extends FormResponse> @NonNull InvalidFormResponseResult<R> invalid(int componentIndex, String errorMessage) {
        return InvalidFormResponseResult.of(componentIndex, errorMessage);
    }

    public static <R extends FormResponse> @NonNull ValidFormResponseResult<R> valid(R formResponse) {
        return ValidFormResponseResult.of(formResponse);
    }

    default public boolean isClosed() {
        return this instanceof ClosedFormResponseResult;
    }

    default public boolean isInvalid() {
        return this instanceof InvalidFormResponseResult;
    }

    default public boolean isValid() {
        return this instanceof ValidFormResponseResult;
    }

    public @NonNull ResultType responseType();
}

