/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.ClientPlayMode;
import org.cloudburstmc.protocol.bedrock.data.InputInteractionModel;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class PlayerAuthInputPacket
implements BedrockPacket {
    private Vector3f rotation;
    private Vector3f position;
    private Vector2f motion;
    private final Set<PlayerAuthInputData> inputData = EnumSet.noneOf(PlayerAuthInputData.class);
    private InputMode inputMode;
    private ClientPlayMode playMode;
    private Vector3f vrGazeDirection;
    private long tick;
    private Vector3f delta;
    private ItemUseTransaction itemUseTransaction;
    private ItemStackRequest itemStackRequest;
    private final List<PlayerBlockActionData> playerActions = new ObjectArrayList<PlayerBlockActionData>();
    private InputInteractionModel inputInteractionModel;
    private Vector2f interactRotation;
    private Vector2f analogMoveVector;
    private long predictedVehicle;
    private Vector2f vehicleRotation;
    private Vector3f cameraOrientation;
    private Vector2f rawMoveVector;

    @Override
    public PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.PLAYER_AUTH_INPUT;
    }

    @Override
    public PlayerAuthInputPacket clone() {
        try {
            return (PlayerAuthInputPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector2f getMotion() {
        return this.motion;
    }

    public Set<PlayerAuthInputData> getInputData() {
        return this.inputData;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public ClientPlayMode getPlayMode() {
        return this.playMode;
    }

    @Deprecated
    public Vector3f getVrGazeDirection() {
        return this.vrGazeDirection;
    }

    public long getTick() {
        return this.tick;
    }

    public Vector3f getDelta() {
        return this.delta;
    }

    public ItemUseTransaction getItemUseTransaction() {
        return this.itemUseTransaction;
    }

    public ItemStackRequest getItemStackRequest() {
        return this.itemStackRequest;
    }

    public List<PlayerBlockActionData> getPlayerActions() {
        return this.playerActions;
    }

    public InputInteractionModel getInputInteractionModel() {
        return this.inputInteractionModel;
    }

    public Vector2f getInteractRotation() {
        return this.interactRotation;
    }

    public Vector2f getAnalogMoveVector() {
        return this.analogMoveVector;
    }

    public long getPredictedVehicle() {
        return this.predictedVehicle;
    }

    public Vector2f getVehicleRotation() {
        return this.vehicleRotation;
    }

    public Vector3f getCameraOrientation() {
        return this.cameraOrientation;
    }

    public Vector2f getRawMoveVector() {
        return this.rawMoveVector;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setMotion(Vector2f motion) {
        this.motion = motion;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public void setPlayMode(ClientPlayMode playMode) {
        this.playMode = playMode;
    }

    @Deprecated
    public void setVrGazeDirection(Vector3f vrGazeDirection) {
        this.vrGazeDirection = vrGazeDirection;
    }

    public void setTick(long tick) {
        this.tick = tick;
    }

    public void setDelta(Vector3f delta) {
        this.delta = delta;
    }

    public void setItemUseTransaction(ItemUseTransaction itemUseTransaction) {
        this.itemUseTransaction = itemUseTransaction;
    }

    public void setItemStackRequest(ItemStackRequest itemStackRequest) {
        this.itemStackRequest = itemStackRequest;
    }

    public void setInputInteractionModel(InputInteractionModel inputInteractionModel) {
        this.inputInteractionModel = inputInteractionModel;
    }

    public void setInteractRotation(Vector2f interactRotation) {
        this.interactRotation = interactRotation;
    }

    public void setAnalogMoveVector(Vector2f analogMoveVector) {
        this.analogMoveVector = analogMoveVector;
    }

    public void setPredictedVehicle(long predictedVehicle) {
        this.predictedVehicle = predictedVehicle;
    }

    public void setVehicleRotation(Vector2f vehicleRotation) {
        this.vehicleRotation = vehicleRotation;
    }

    public void setCameraOrientation(Vector3f cameraOrientation) {
        this.cameraOrientation = cameraOrientation;
    }

    public void setRawMoveVector(Vector2f rawMoveVector) {
        this.rawMoveVector = rawMoveVector;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerAuthInputPacket)) {
            return false;
        }
        PlayerAuthInputPacket other = (PlayerAuthInputPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.tick != other.tick) {
            return false;
        }
        if (this.predictedVehicle != other.predictedVehicle) {
            return false;
        }
        Vector3f this$rotation = this.rotation;
        Vector3f other$rotation = other.rotation;
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector2f this$motion = this.motion;
        Vector2f other$motion = other.motion;
        if (this$motion == null ? other$motion != null : !this$motion.equals(other$motion)) {
            return false;
        }
        Set<PlayerAuthInputData> this$inputData = this.inputData;
        Set<PlayerAuthInputData> other$inputData = other.inputData;
        if (this$inputData == null ? other$inputData != null : !((Object)this$inputData).equals(other$inputData)) {
            return false;
        }
        InputMode this$inputMode = this.inputMode;
        InputMode other$inputMode = other.inputMode;
        if (this$inputMode == null ? other$inputMode != null : !((Object)((Object)this$inputMode)).equals((Object)other$inputMode)) {
            return false;
        }
        ClientPlayMode this$playMode = this.playMode;
        ClientPlayMode other$playMode = other.playMode;
        if (this$playMode == null ? other$playMode != null : !((Object)((Object)this$playMode)).equals((Object)other$playMode)) {
            return false;
        }
        Vector3f this$vrGazeDirection = this.vrGazeDirection;
        Vector3f other$vrGazeDirection = other.vrGazeDirection;
        if (this$vrGazeDirection == null ? other$vrGazeDirection != null : !this$vrGazeDirection.equals(other$vrGazeDirection)) {
            return false;
        }
        Vector3f this$delta = this.delta;
        Vector3f other$delta = other.delta;
        if (this$delta == null ? other$delta != null : !this$delta.equals(other$delta)) {
            return false;
        }
        ItemUseTransaction this$itemUseTransaction = this.itemUseTransaction;
        ItemUseTransaction other$itemUseTransaction = other.itemUseTransaction;
        if (this$itemUseTransaction == null ? other$itemUseTransaction != null : !((Object)this$itemUseTransaction).equals(other$itemUseTransaction)) {
            return false;
        }
        ItemStackRequest this$itemStackRequest = this.itemStackRequest;
        ItemStackRequest other$itemStackRequest = other.itemStackRequest;
        if (this$itemStackRequest == null ? other$itemStackRequest != null : !((Object)this$itemStackRequest).equals(other$itemStackRequest)) {
            return false;
        }
        List<PlayerBlockActionData> this$playerActions = this.playerActions;
        List<PlayerBlockActionData> other$playerActions = other.playerActions;
        if (this$playerActions == null ? other$playerActions != null : !((Object)this$playerActions).equals(other$playerActions)) {
            return false;
        }
        InputInteractionModel this$inputInteractionModel = this.inputInteractionModel;
        InputInteractionModel other$inputInteractionModel = other.inputInteractionModel;
        if (this$inputInteractionModel == null ? other$inputInteractionModel != null : !((Object)((Object)this$inputInteractionModel)).equals((Object)other$inputInteractionModel)) {
            return false;
        }
        Vector2f this$interactRotation = this.interactRotation;
        Vector2f other$interactRotation = other.interactRotation;
        if (this$interactRotation == null ? other$interactRotation != null : !this$interactRotation.equals(other$interactRotation)) {
            return false;
        }
        Vector2f this$analogMoveVector = this.analogMoveVector;
        Vector2f other$analogMoveVector = other.analogMoveVector;
        if (this$analogMoveVector == null ? other$analogMoveVector != null : !this$analogMoveVector.equals(other$analogMoveVector)) {
            return false;
        }
        Vector2f this$vehicleRotation = this.vehicleRotation;
        Vector2f other$vehicleRotation = other.vehicleRotation;
        if (this$vehicleRotation == null ? other$vehicleRotation != null : !this$vehicleRotation.equals(other$vehicleRotation)) {
            return false;
        }
        Vector3f this$cameraOrientation = this.cameraOrientation;
        Vector3f other$cameraOrientation = other.cameraOrientation;
        if (this$cameraOrientation == null ? other$cameraOrientation != null : !this$cameraOrientation.equals(other$cameraOrientation)) {
            return false;
        }
        Vector2f this$rawMoveVector = this.rawMoveVector;
        Vector2f other$rawMoveVector = other.rawMoveVector;
        return !(this$rawMoveVector == null ? other$rawMoveVector != null : !this$rawMoveVector.equals(other$rawMoveVector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerAuthInputPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tick = this.tick;
        result = result * 59 + (int)($tick >>> 32 ^ $tick);
        long $predictedVehicle = this.predictedVehicle;
        result = result * 59 + (int)($predictedVehicle >>> 32 ^ $predictedVehicle);
        Vector3f $rotation = this.rotation;
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector2f $motion = this.motion;
        result = result * 59 + ($motion == null ? 43 : $motion.hashCode());
        Set<PlayerAuthInputData> $inputData = this.inputData;
        result = result * 59 + ($inputData == null ? 43 : ((Object)$inputData).hashCode());
        InputMode $inputMode = this.inputMode;
        result = result * 59 + ($inputMode == null ? 43 : ((Object)((Object)$inputMode)).hashCode());
        ClientPlayMode $playMode = this.playMode;
        result = result * 59 + ($playMode == null ? 43 : ((Object)((Object)$playMode)).hashCode());
        Vector3f $vrGazeDirection = this.vrGazeDirection;
        result = result * 59 + ($vrGazeDirection == null ? 43 : $vrGazeDirection.hashCode());
        Vector3f $delta = this.delta;
        result = result * 59 + ($delta == null ? 43 : $delta.hashCode());
        ItemUseTransaction $itemUseTransaction = this.itemUseTransaction;
        result = result * 59 + ($itemUseTransaction == null ? 43 : ((Object)$itemUseTransaction).hashCode());
        ItemStackRequest $itemStackRequest = this.itemStackRequest;
        result = result * 59 + ($itemStackRequest == null ? 43 : ((Object)$itemStackRequest).hashCode());
        List<PlayerBlockActionData> $playerActions = this.playerActions;
        result = result * 59 + ($playerActions == null ? 43 : ((Object)$playerActions).hashCode());
        InputInteractionModel $inputInteractionModel = this.inputInteractionModel;
        result = result * 59 + ($inputInteractionModel == null ? 43 : ((Object)((Object)$inputInteractionModel)).hashCode());
        Vector2f $interactRotation = this.interactRotation;
        result = result * 59 + ($interactRotation == null ? 43 : $interactRotation.hashCode());
        Vector2f $analogMoveVector = this.analogMoveVector;
        result = result * 59 + ($analogMoveVector == null ? 43 : $analogMoveVector.hashCode());
        Vector2f $vehicleRotation = this.vehicleRotation;
        result = result * 59 + ($vehicleRotation == null ? 43 : $vehicleRotation.hashCode());
        Vector3f $cameraOrientation = this.cameraOrientation;
        result = result * 59 + ($cameraOrientation == null ? 43 : $cameraOrientation.hashCode());
        Vector2f $rawMoveVector = this.rawMoveVector;
        result = result * 59 + ($rawMoveVector == null ? 43 : $rawMoveVector.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerAuthInputPacket(rotation=" + this.rotation + ", position=" + this.position + ", motion=" + this.motion + ", inputData=" + this.inputData + ", inputMode=" + (Object)((Object)this.inputMode) + ", playMode=" + (Object)((Object)this.playMode) + ", vrGazeDirection=" + this.vrGazeDirection + ", tick=" + this.tick + ", delta=" + this.delta + ", itemUseTransaction=" + this.itemUseTransaction + ", itemStackRequest=" + this.itemStackRequest + ", playerActions=" + this.playerActions + ", inputInteractionModel=" + (Object)((Object)this.inputInteractionModel) + ", interactRotation=" + this.interactRotation + ", analogMoveVector=" + this.analogMoveVector + ", predictedVehicle=" + this.predictedVehicle + ", vehicleRotation=" + this.vehicleRotation + ", cameraOrientation=" + this.cameraOrientation + ", rawMoveVector=" + this.rawMoveVector + ")";
    }
}

